using System;

namespace nft.framework
{
	/// <summary>
	/// IHasNameAndID ̊Tv̐łB
	/// </summary>
	public interface IHasNameAndID
	{
        IIdentifier ID {get;}
		string Name {get;}
	}

    public static class IHasNameAndIDExtension
    {
        public static bool Equals(this IHasNameAndID me, object target)
        {
            IHasNameAndID another = target as IHasNameAndID;
            if (another == null) return false;
            return me.ID.Equals(another.ID) && me.GetType().Equals(another.GetType());
        }

        public static int GetHashCode(this IHasNameAndID me)
        {
            return me.ID.GetHashCode();
        }

        public static string ToString(this IHasNameAndID me)
        {
            return String.Format("{0}#{1}'{2}'", me.GetType().Name, me.ID.AsString, me.Name);
        }
    }
}
