﻿using nft.core.game;
using nft.core.geometry;
using nft.core.view;
using nft.framework.drawing;
using System;
using System.Collections.Generic;
using System.Drawing;
using System.Text;
using Geocon = nft.core.geometry.GeometricConstants;

namespace nft.impl.view {
    public class SelectionInfo {
        public readonly IGame Game;
        public readonly SceneBuilder SceneBuilder;
        public readonly Point ScreenPosition; // position of mouse cursor.

        public SelectionInfo(IGame game, SceneBuilder builder, Point screen) {
            this.Game = game;
            this.SceneBuilder = builder;
            this.ScreenPosition = screen;
        }

        // Fields that indicates current selection --
        public PointF3D WorldPosition; // simple 2D/3D conversion of coordination.
        public Location Location; // in grid unit
        public Point Offset;
        public UInt32 HitTestValue;
        public ITerrainPiece TerrainPiece;
        public ITerrainPolygon Polygon;
        public object Object;
        // -- End of fields

        public ISurface Surface {
            get { return SceneBuilder.surface; }
        }

        public ITerrainMap TerrainMap {
            get { return SceneBuilder.game.TerrainMap;  }
        }

    }
}
