﻿using System;
using System.Collections.Generic;
using System.Text;

namespace nft.core.view
{
    //public enum SelectionState { NONE = 0, NORMAL, WARN, DANGER }
    public delegate void TargetSelectorEvent(SelectionEventArgs args);

    public class SelectionEventArgs
    {
        public enum EventTypes {SELECTION_CHANGED, PHASE_PROCEEDED, PHASE_ROLLBACKED, VIEW_CHANGED ,COMPLETED, CANCELD }
        
        protected ITargetSelector selector;
        protected EventTypes status;

        public SelectionEventArgs(ITargetSelector sel, EventTypes stat) {
            this.selector = sel;
            this.status = stat;
        }

        EventTypes EventType {
            get {
                return status;
            }
            set {
                status = value;
            }
        }

        ITargetSelector TargetSelector {
            get {
                return selector;
            }
        }

    }

    public interface ITargetSelector
    {
        int MaxPhases { get; }
        int CurrentPhase { get; }
        object CurrentSelection { get; }
        event TargetSelectorEvent OnSelectionChanged;
        event TargetSelectorEvent OnPhaseChanged;
        event TargetSelectorEvent OnViewChanged;
    }
}
