﻿using System;
using System.Collections.Generic;
using System.Text;
using nft.framework.plugin;
using nft.framework.drawing;
using System.Xml;
using nft.util;
using nft.framework;
using System.Drawing;
using System.IO;
using nft.core;
using nft.core.view;

namespace nft.contributions.graphics
{
    public class CtbImageResource : Contribution {
        protected ConditionedResource<ImageResource> conditionedResource;

        public CtbImageResource(Plugin owner, ParamsReader contrib) : base(owner, contrib)
        {
            conditionedResource = ConditionedResourceFactory.LoadAsConditiondResources<ImageResource>(contrib, new ResourceParser<ImageResource>(Parse));
        }

        protected ImageResource Parse(ParamsReader reader) {
            return new ImageResource(Parent, reader);
        }

        public  ConditionedResource<ImageResource> Data {
            get {
                return conditionedResource;
            }
        }

        protected override string ParseName(ParamsReader r) {
            ParamsReader rn = r["name"];
            rn = rn.IsNull? r["default|value"]["src"]:rn;
            return rn.InnerText;
        }
    }

    public class ImageResource
    {
        protected ResourceKey res_key;
        protected WeakReference reffer;
        protected Color colorkey;
        protected bool auto_color_key;
        protected string src_text;
        protected IFileSource file;

        public ImageResource(Plugin owner, ParamsReader contrib)
        {
            reffer = null;
            ParamsReader nd = contrib["src"];
            src_text = nd.InnerText;
            file = contrib.GetFileSource(src_text);
            ParamsReader ckey = nd["colorkey"];
            auto_color_key = ckey.IsNull;
            if (auto_color_key)
            {
                colorkey = Color.Transparent;
            }
            else
            {
                colorkey = StringParseUtil.CreateColor(ckey.InnerText);
            }
            res_key = ResourceKey.CreateKey(owner, SrcText);
        }

        protected string SrcText
        {
            // 'name' holds inner text of <src> element.
            get { return src_text; }
        }

        public IFileSource File
        {
            get{ return file; }
        }

        public IImageSrc ImageSrc
        {
            get
            {
                if (reffer != null && reffer.IsAlive) {
                    return (IImageSrc)reffer.Target;
                } else {
                    // Image file might be shared by contributions in the same plugin. So assign plugin key.
                    IImageSrc img;
                    if (auto_color_key) {
                        // use left-bottom pixel as color-key
                        img = GraphicManagerEx.GraphicManager.LoadImageFromFileWithDefaultColorKey(res_key, File);
                    } else {
                        img = GraphicManagerEx.GraphicManager.LoadImageFromFile(res_key, File, colorkey);
                    }
                    reffer = new WeakReference(img);
                    return img;
                }
            }
        }
    }
}
