using System;
using System.Collections;
using System.Diagnostics;
using System.Drawing;
using System.Reflection;
using System.Xml;
using nft.framework;
using nft.framework.plugin;
using nft.core.game;
using nft.core.geometry;
using nft.core.structure;
using nft.util;
using System.Windows.Forms;

namespace nft.contributions.game
{
	/// <summary>
	/// CommandEntityContributuion ̊Tv̐łB
	/// </summary>
    public abstract class CtbTerrainGenerator : CtbMapGenerator, ITerrainGenerator
	{
        public CtbTerrainGenerator(Plugin p, ParamsReader contrib) : base(p, contrib) { }
		public abstract ITerrainGenerator Generator { get; }
		public static Array ListEnabled()
		{ 
			Type t = typeof(CtbTerrainGenerator);
			return PluginManager.theInstance.ListContributions(t,true);
		}
		public override bool IsDetachable { get	{ return true; } }

        #region ITerrainGenerator o
        public abstract ITerrainMap Generate(ParamSet param);
        #endregion
    }

	public class CtbFlatTerrainGenerator : CtbTerrainGenerator
	{
		public const string KEY_MAX_HEIGHT = "MaxHeight";
		public const string KEY_GROUND_LEVEL = "GroundLevel";

        public CtbFlatTerrainGenerator(Plugin p, ParamsReader contrib) : base(p, contrib) { }		
		public override ITerrainGenerator Generator { get {	return this; } }

		#region ITerrainGenerator o
		protected ParamSet param;
		
        public void DisposeSetupPanel(bool apply) {
            throw new NotImplementedException();
        }

        public override ITerrainMap Generate(ParamSet param) 
		{ 
			int mxh = param[KEY_MAX_HEIGHT, MapGeneService.SystemMaxHeight];
			int asl = param[KEY_GROUND_LEVEL, MapGeneService.DefaultAboveSeaLevel];
			ITerrainMap map = new FlatMap(new Size(100,100),(short)asl,(short)mxh);
			return map; 
		}
        #endregion
    }

	public class FlatMap : ITerrainMap
	{
		protected short maxHeight = MapGeneService.SystemMaxHeight;
		protected short groundLv = MapGeneService.DefaultAboveSeaLevel;
		protected ParamSet param = new ParamSet();

		protected Rectangle[] districts;
		protected Lot[] lots;

		public FlatMap(Size sz, short groundLevel, short maxHeight)
		{
			this.size = sz;
			this.maxHeight = maxHeight;
			this.groundLv = groundLevel;
		}

		#region ITerrainMap o
		public Size3D Size { get { return size; } }
        protected Size3D size;

		public bool IsDetailedHeight { get { return false; } }

        public int Height(int x, int y) { 
			if( x<0 || x>= size.sx || y< 0 || y>=size.sy )
				return -1;
			else
				return groundLv; 
		}

        public bool IsCliffedBounds(Direction4 direction4, int x, int y) {
            return false;
        }

        public int DetailedHeight(double x, double y) {
            return -1;
        }

		public int WaterDepth(int x, int y)	{ return -1; }

        public int HeightOffset { get { return 0; } }


		public Rectangle[] Districts 
		{
			get { return districts; }
			set { districts = value; }
		}
		public Lot[] Lots 
		{
			get { return lots; }
			set { lots = value; }
		}
		public ParamSet GlobalParams { get { return param; } }

        public void Dispose() {
            // do notihing
        }
        #endregion
    }

}
