﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.Security.Permissions;
using System.Diagnostics;

namespace nft.test.test {
    public partial class KeyControlForm : Form {
        public KeyControlForm() {
            InitializeComponent();
        }

        [UIPermission(SecurityAction.Demand,Window = UIPermissionWindow.AllWindows)]
        protected override bool ProcessDialogKey(Keys keyData) {
            Debug.WriteLine("ProcessDialogKey:" + keyData);
            //本来の処理をさせたくないときは、trueを返す
            return true;
            //return base.ProcessDialogKey(keyData);
        }
        [UIPermission(SecurityAction.Demand, Window = UIPermissionWindow.AllWindows)]
        protected override bool ProcessTabKey(bool forward) {
            Debug.WriteLine("ProcessTabKey");
            return true;
        }

        protected override bool ProcessCmdKey(ref Message msg, Keys keyData) {
            Debug.WriteLine("ProcessCmdKey:" + keyData);
            return base.ProcessCmdKey(ref msg, keyData);
        }
        protected override bool ProcessDialogChar(char charCode) {
            Debug.WriteLine("ProcessDialogChar:" + new string(charCode,1)+", "+ (uint)charCode);
            return base.ProcessDialogChar(charCode);
        }

        private void KeyControlForm_KeyDown(object sender, KeyEventArgs e) {
            e.Handled = true; // 子コントロールにイベントを渡さない
            Debug.WriteLine("Event KeyDown:" + e.KeyCode + ", " + e.KeyValue);
        }

        private void KeyControlForm_PreviewKeyDown(object sender, PreviewKeyDownEventArgs e) {
            Debug.WriteLine("Event PreviewKeyDown:" + e.KeyCode + ", " + e.KeyValue+", inputKey="+e.IsInputKey);
        }

    }
}
