#include "ViewTerrain.h"

#include "./Sequence/MainGameSequence.h"
#include "./MainGameViewManager.h"
#include "./MainGameDataManager.h"

#include "ChipsetTag.h"
#include "TerrainTag.h"

using namespace Blast::Base;
using namespace Blast::Graphic;


//====================================================================================================
// Operation
//----------------------------------------------------------------------------------------------------

/// RXgN^
ViewTerrain::ViewTerrain(MainGameViewManager* pViewManager)
	: mPViewManager(pViewManager)
	, mIsEnable(true)
	, mIsVisible(true)
{
	// n`̃`bvZbg쐬
	mPChipset.SetPointer(NEW TerrainChipset());
	
	// VF[_[ǂݍ
	ResourceManager* pRM = ResourceManager::GetInstance();
	SP<ShaderEffectDX9> pShader = pRM->Load<ShaderEffectDX9>(ShaderEffectDX9::ToFilePath(ShaderEffectDX9::eSHADEREFFECT_STANDARD_CONSTANT));
	#if _DEBUG
	pShader->SetTechnique(ShaderEffectDX9::ToTechniqueName(ShaderEffectDX9::eTECHNIQUE_CONSTANT_WIREFRAME));
	#else
	pShader->SetTechnique(ShaderEffectDX9::ToTechniqueName(ShaderEffectDX9::eTECHNIQUE_CONSTANT));
	#endif	// _DEBUG
	mPShader = pShader;
}

/// fXgN^
ViewTerrain::~ViewTerrain()
{
}


/// XV
void ViewTerrain::Update(float delta)
{
	if (!mIsEnable)
	{
		return;
	}
}

/// `
void ViewTerrain::Render()
{
	if (!mIsVisible)
	{
		return;
	}

	// n`
	SP<TerrainGrid> pTG = GetDataMgr()->GetTerrainGrid();
	if (pTG)
	{
		unsigned passCount = 0;
		mPShader->Begin(&passCount);

		const int kTileCount = pTG->GetTiles()->size();
		for (int i = 0; i < kTileCount; ++i)
		{
			SP<TerrainGrid::STile> pSTile = pTG->GetTileAt(i);
			if (!pSTile->mIsVisible)
			{
				continue;
			}

			SP<TerrainChipset::SChip> pChip = mPChipset->GetChipAt( pSTile->mECategoryTag );
			if (!pChip)
			{
				HALT(_T("Chip擾ł܂łB"));
				continue;
			}

			SP<ICamera> pCamera = GetDataMgr()->GetCamera();
			pChip->mPModel->SetCamera(pCamera);
			pChip->mPModel->SetPosition(pSTile->mWorldPosition);
			pChip->mPModel->SetShaderEffect(mPShader);
			pChip->mPModel->SetBeganShader(true, passCount);
			pChip->mPModel->Render();
		}
		
		mPShader->End();
	}
}

/// n`̃`bvZbgݒ
void ViewTerrain::SetChipset(ChipsetTag::EChipsetTag eTag)
{
	mPChipset->CreateChipset(eTag);
}


//====================================================================================================
// Property
//----------------------------------------------------------------------------------------------------

/// XVtO擾
bool ViewTerrain::IsEnable() const
{
	return mIsEnable;
}

/// XVtOݒ
void ViewTerrain::SetEnable(bool value)
{
	mIsEnable = value;
}

///< `tO擾
bool ViewTerrain::IsVisible() const
{
	return mIsVisible;
}

///< `tOݒ
void ViewTerrain::SetVisible(bool value)
{
	mIsVisible = value;
}


	
//====================================================================================================
// Implement
//----------------------------------------------------------------------------------------------------

/// Ǘ擾
SP<MainGameDataManager> ViewTerrain::GetDataMgr()
{
	return mPViewManager->GetSequence()->GetDataManager();
}