#include "ViewDropItem.h"

#include "./Sequence/MainGameSequence.h"
#include "./MainGameViewManager.h"
#include "./MainGameDataManager.h"

#include "ItemDatabase.h"

using namespace Blast::Base;
using namespace Blast::Graphic;


//====================================================================================================
// Operation
//----------------------------------------------------------------------------------------------------

/// RXgN^
ViewDropItem::ViewDropItem(MainGameViewManager* pViewManager)
	: mPViewManager(pViewManager)
	, mIsVisible(true)
{
	// `bvZbg쐬
	mPChipset.SetPointer(NEW DropItemChipset());

	// VF[_[ǂݍ
	ResourceManager* pRM = ResourceManager::GetInstance();
	mPShader = pRM->Load<ShaderEffectDX9>(ShaderEffectDX9::ToFilePath(ShaderEffectDX9::eSHADEREFFECT_STANDARD_CONSTANT));
	#if _DEBUG
	mPShader->SetTechnique(ShaderEffectDX9::ToTechniqueName(ShaderEffectDX9::eTECHNIQUE_CONSTANT_WIREFRAME));
	#else
	mPShader->SetTechnique(ShaderEffectDX9::ToTechniqueName(ShaderEffectDX9::eTECHNIQUE_CONSTANT));
	#endif	// _DEBUG
}

/// fXgN^
ViewDropItem::~ViewDropItem()
{
}

/// `
void ViewDropItem::Render()
{
	if (!mIsVisible)
	{
		return;
	}

	// `bv̎ނŃ[vJn̂́A܂Ƃ߂ĕ`悷錜O߁B
	// HACK:VF[_[beginĂĈCɕ`悷̂ǂB
	// HACK:Update\bhpӂāA`悷ׂ\ߍ\zĂ̂ǂƎvB
	for (int i = 0; i < (int)mPChipset->GetChips()->size(); ++i)
	{
		// ނ肵AΏۂ̃`bvŕ`悷
		const DropItemManager::DropItemList& kRDropItems = GetDataMgr()->GetDropItemManager()->GetDropItemList();
		DropItemManager::DropItemList::const_iterator kIt;
		for (kIt = kRDropItems.begin(); kIt != kRDropItems.end(); ++kIt)
		{
			// ̎擾
			const ItemDatabase::SCatalog* kPCatalog = ItemDatabase::GetInstance()->GetCatalogAt( (*kIt)->mEItemTag );
			ASSERT_PF(kPCatalog, _T("擾ł܂łB"));
			if (!kPCatalog)
			{
				continue;
			}

			// ނ̈v
			if (i != kPCatalog->mKindID)
			{
				continue;
			}
			
			// `bv̏̎擾
			SP<DropItemChipset::SChip> pChip = mPChipset->GetChipAt(i);
			ASSERT_PF(pChip, _T("`bv擾ł܂łB"));
			if (!pChip)
			{
				continue;
			}

			// ʒu
			SP<TerrainGrid::STile> pTile = GetDataMgr()->GetTerrainGrid()->GetTileAt( (*kIt)->mGridPosition );
			if (pTile)
			{
				pChip->mPModel->SetPosition( pTile->mWorldPosition );
			}

			pChip->mPModel->SetCamera( GetDataMgr()->GetCamera() );
			pChip->mPModel->SetShaderEffect(mPShader);
			pChip->mPModel->Render();
		}
	}
}


//====================================================================================================
// Property
//----------------------------------------------------------------------------------------------------

///< `tO擾
bool ViewDropItem::IsVisible() const
{
	return mIsVisible;
}

///< `tOݒ
void ViewDropItem::SetVisible(bool value)
{
	mIsVisible = value;
}


//====================================================================================================
// Implement
//----------------------------------------------------------------------------------------------------

/// Ǘ擾
SP<MainGameDataManager> ViewDropItem::GetDataMgr()
{
	return mPViewManager->GetSequence()->GetDataManager();
}