#include "UnitManager.h"

using namespace Blast::Math;


//====================================================================================================
// Operation
//----------------------------------------------------------------------------------------------------

/// RXgN^
UnitManager::UnitManager()
{
}

/// fXgN^
UnitManager::~UnitManager()
{
}

/// XV
void UnitManager::Update(float delta)
{
	UnitList::iterator it;
	for (it = mUnits.begin(); it != mUnits.end(); ++it)
	{
		(*it)->Update(delta);
	}
}

/// ǉ
void UnitManager::AddUnit(SP<Unit> value)
{
	mUnits.push_back(value);
}

/// O
void UnitManager::RemoveUnit(SP<Unit> value)
{
	mUnits.remove(value);
}

/// SďO
void UnitManager::ClearUnit()
{
	mUnits.clear();
}

/// CfbNXwŎ擾
SP<Unit> UnitManager::GetUnitAt(int index)
{
	const bool kIsInOfRange = MathHelper::IsInOfRange<int>(index, mUnits.size());
	ASSERT_PF(kIsInOfRange, _T("CfbNX͈͊OwĂ܂B\nindex=%d"), index);
	if (!kIsInOfRange)
	{
		return SP<Unit>();
	}

	UnitList::iterator it;
	std::advance(it, index);
	return (*it);
}

/// ̐擾
int UnitManager::GetUnitCount() const
{
	return mUnits.size();
}

/// 1ȏ゠邩ƍ
bool UnitManager::IsEmpty() const
{
	return mUnits.empty();
}

/// ɊỸXg擾
void UnitManager::GetRoleUnits(UnitList* kRDest, Unit::ERole eRole)
{
	UnitList::iterator it;
	for (it = mUnits.begin(); it != mUnits.end(); ++it)
	{
		if ( (*it)->GetRoleTag() == eRole )
		{
			kRDest->push_back( (*it) );
		}
	}
}

/// vC[̋擾
SP<Unit> UnitManager::GetPlayerUnit()
{
	// vC[1̂̂ݑ݂͂Ȃ̂ŁAŏ1̂炻Ԃ
	UnitList::iterator it;
	for (it = mUnits.begin(); it != mUnits.end(); ++it)
	{
		if ( (*it)->GetRoleTag() == Unit::eROLE_PLAYER )
		{
			return (*it);
		}
	}

	WARNING(NULL, _T("vC[̋1܂B"));
	return SP<Unit>();
}


//====================================================================================================
// Property
//----------------------------------------------------------------------------------------------------

/// R}Xg擾
const UnitManager::UnitList* UnitManager::GetUnits() const
{
	return &mUnits;
}