#include "TrapCatalogData.h"

using namespace Blast::IO;


//====================================================================================================
// Operation
//----------------------------------------------------------------------------------------------------

/// RXgN^
TrapCatalogData::TrapCatalogData() :
mID(-1),
mTag(-1),
mNameStr(_T("")),
mDisplayNameStr(_T("")),
mOperationPercentUndiscovered(-1),
mOperationPercentDiscovered(-1),
mModelFilePathStr(_T("")),
mDiscriptionStr(_T(""))
{
}

/// fXgN^
TrapCatalogData::~TrapCatalogData()
{
}


/// ǂݍ
void TrapCatalogData::Load(const SP<CSVRecord> pRecord)
{
	mID = pRecord->GetItem(_T("ID"))->GetValueRef().ToInteger();
	mTag = pRecord->GetItem(_T("^O"))->GetValueRef().ToInteger();
	mNameStr = pRecord->GetItem(_T("O"))->GetValueRef().GetValueStrRef();
	mDisplayNameStr = pRecord->GetItem(_T("\"))->GetValueRef().GetValueStrRef();
	mOperationPercentUndiscovered = pRecord->GetItem(_T("쓮m"))->GetValueRef().ToInteger();
	mOperationPercentDiscovered = pRecord->GetItem(_T("쓮m"))->GetValueRef().ToInteger();
	mModelFilePathStr = pRecord->GetItem(_T("ft@CpX"))->GetValueRef().GetValueStrRef();
	mDiscriptionStr = pRecord->GetItem(_T(""))->GetValueRef().GetValueStrRef();
}


/// ID擾
int TrapCatalogData::GetID() const
{
	return mID;
}