#ifndef TERRAINGRID_H
#define TERRAINGRID_H

#include <vector>


/// n`̏SB{ɏ񂾂BMVCMSB
class TerrainGrid
{
	//====================================================================================================
	// Enumerate
	//----------------------------------------------------------------------------------------------------

public:
	/// n`̃^C̎ށBʂ̏ꏊɂׂ́B
	enum ETileCategoryTag
	{
		eTILE_CATEGORY_NONE,
		eTILE_CATEGORY_GROUND,
		eTILE_CATEGORY_WALL,

		eTILE_CATEGORY_COUNT,
	};


	//====================================================================================================
	// Struct
	//----------------------------------------------------------------------------------------------------

public:
	/// ^C
	struct STile
	{
		ETileCategoryTag mECategoryTag;
		Blast::Math::Point mGridPosition;
		Blast::Math::Vector3 mWorldPosition;
		bool mIsEnable;
		bool mIsVisible;
	};


	//====================================================================================================
	// Alias
	//----------------------------------------------------------------------------------------------------

public:
	/// ^CXǧ^
	typedef std::vector< SP<STile> > TileList;


	//====================================================================================================
	// Operation
	//----------------------------------------------------------------------------------------------------

public:
	/// RXgN^
	TerrainGrid();
	/// fXgN^
	~TerrainGrid();

	/// ÓIf[^ŎQƂč쐬
	void CreateGrid(int id);	///< HACK:񋓑̂̕ǂB

	/// ^Cǉ
	void AddTile(SP<STile> pSTile);
	/// ^CO
	void RemoveTile(SP<STile> pSTile);
	/// ^CCfbNXwŏO
	void RemoveTileAt(int index);

	/// CfbNXwŃ^C擾
	SP<STile> GetTileAt(int index);
	/// ObhʒuwŃ^C擾
	SP<STile> GetTileAt(int x, int y);
	/// ObhʒuwŃ^C擾
	SP<STile> GetTileAt(const Blast::Math::Point& kRGridPoint);


	//====================================================================================================
	// Property
	//----------------------------------------------------------------------------------------------------

public:
	/// ^CXg擾
	const TileList* GetTiles() const;

	/// 1s̃^C擾
	int GetLineTileCount() const;
	/// 1s̃^Cݒ
	void SetLineTileCount(int value);


	//====================================================================================================
	// Field
	//----------------------------------------------------------------------------------------------------

private:
	/// ^CXg
	TileList mTiles;

	/// 1s̃^C
	int mLineTileCount;
};

#endif // TERRAINGRID_H