#include "TerrainGrid.h"

#include "MapDataManager.h"
#include "Chip.h"

using namespace Blast::Base;
using namespace Blast::Math;
using namespace Blast::Graphic;


//====================================================================================================
// Operation
//----------------------------------------------------------------------------------------------------

/// RXgN^
TerrainGrid::TerrainGrid()
	: mLineTileCount(0)
{
}

/// fXgN^
TerrainGrid::~TerrainGrid()
{
}

/// ÓIf[^ŎQƂč쐬
void TerrainGrid::CreateGrid(int id)
{
	MapDataManager* pMDMgr = MapDataManager::GetInstance();
	TerrainTag::ETerrainTag eFloorTag = TerrainTag::ToTag(id);
	const MapDataManager::SFloorPlacementData& kRSData = pMDMgr->GetFloorPlacementData(eFloorTag);

	// tA̍\
	const float kTileSize = 100.0f;
	const float kHalfTileSize = kTileSize * 0.5f;
	const Vector3 kWorldOffset(
		-kHalfTileSize * (MapDataManager::MAX_TILE_HORIZON_COUNT - 1),
		0.0f,
		-kHalfTileSize * (MapDataManager::MAX_TILE_VERTICAL_COUNT - 1)
		);

	for (int i = 0; i < MapDataManager::MAX_TILE_TOTAL_COUNT; ++i)
	{
		// ʒu
		int x = i % MapDataManager::MAX_TILE_HORIZON_COUNT;
		int y = i / MapDataManager::MAX_TILE_HORIZON_COUNT;
		Blast::Math::Point tilePos(x, y);

		Vector3 worldPos(x * kTileSize, 0.0f, y * kTileSize);
		worldPos += kWorldOffset;
		worldPos.mZ *= -1;	// Ղ猩񎟌W̔zuɂׁAZ͋tɂB

		SP<STile> pTile(NEW STile());
		ETileCategoryTag eCategoryTag = static_cast<ETileCategoryTag>(kRSData.mChipIndices[i]);
		pTile->mECategoryTag = eCategoryTag;
		pTile->mGridPosition = tilePos;
		pTile->mWorldPosition = worldPos;
		pTile->mIsEnable = true;
		pTile->mIsVisible = true;

		mTiles.push_back(pTile);
	}

	// ÔߕϐɕێĂ
	mLineTileCount = MapDataManager::MAX_TILE_HORIZON_COUNT;
}

/// ^Cǉ
void TerrainGrid::AddTile(SP<STile> pSTile)
{
	mTiles.push_back(pSTile);
}

/// ^CO
void TerrainGrid::RemoveTile(SP<STile> pSTile)
{
	TileList::iterator it;
	for (it = mTiles.begin(); it != mTiles.end(); ++it)
	{
		if ( (*it) == pSTile)
		{
			mTiles.erase(it);
			break;
		}
	}
}

/// ^CCfbNXwŏO
void TerrainGrid::RemoveTileAt(int index)
{
	TileList::iterator it = mTiles.begin();
	std::advance(it, index);
	mTiles.erase(it);
}

/// CfbNXwŃ^C擾
SP<TerrainGrid::STile> TerrainGrid::GetTileAt(int index)
{
	return mTiles.at(index);
}

/// ObhʒuwŃ^C擾
SP<TerrainGrid::STile> TerrainGrid::GetTileAt(int x, int y)
{
	return GetTileAt(x + y * mLineTileCount);
}

/// ObhʒuwŃ^C擾
SP<TerrainGrid::STile> TerrainGrid::GetTileAt(const Point& kRGridPoint)
{
	return GetTileAt(kRGridPoint.mX, kRGridPoint.mY);
}


//====================================================================================================
// Property
//----------------------------------------------------------------------------------------------------

/// ^CXg擾
const TerrainGrid::TileList* TerrainGrid::GetTiles() const
{
	return &mTiles;
}

/// 1s̃^C擾
int TerrainGrid::GetLineTileCount() const
{
	return mLineTileCount;
}

/// 1s̃^Cݒ
void TerrainGrid::SetLineTileCount(int value)
{
	mLineTileCount = value;
}