#include "MainMenuSequence.h"

#include "Blast/Graphic/DirectX9/FileTexture2DDX9.h"

#include "ItemDatabase.h"

using namespace Blast::Base;
using namespace Blast::Input;
using namespace Blast::Design;


//====================================================================================================
// Operation
//----------------------------------------------------------------------------------------------------

/// RXgN^
MainMenuSequence::MainMenuSequence(bool isPopup)
	: SequenceBase(isPopup)
	, mPStateController(NULL)
	, mPDataManager(NULL)
{
	// Ԃ͏𑀍삷̂ŁAɍ
	mPDataManager.SetPointer(NEW MainMenuDataManager());
	mPStateController.SetPointer(NEW MainMenuStateController(this));
}

/// fXgN^
MainMenuSequence::~MainMenuSequence() { }

/// 
void MainMenuSequence::Initialize()
{
	SequenceBase::Initialize();
}

/// 
void MainMenuSequence::HandleInput(float delta)
{
	SequenceBase::HandleInput(delta);
	mPDataManager->HandleInput(delta);
	mPStateController->HandleInput(delta);
}

/// XV
void MainMenuSequence::Update(float delta)
{
	// ̍XV
	SequenceBase::Update(delta);
	mPDataManager->Update(delta);
	mPStateController->Update(delta);
}

/// `
void MainMenuSequence::Render()
{
	SequenceBase::Render();
	mPDataManager->Render();
	mPStateController->Render();
}

/// ^Cv擾
int MainMenuSequence::GetType() const
{
	return SequenceEnum::eSEQ_MAINGAME;
}


//====================================================================================================
// Property
//----------------------------------------------------------------------------------------------------

/// Ǘ擾
SP<MainMenuDataManager> MainMenuSequence::GetDataManager()
{
	return mPDataManager;
}

/// Ԑ擾
SP<MainMenuStateController> MainMenuSequence::GetStateController()
{
	return mPStateController;
}