#include "Sequence/Debug/DebugSequenceSpriteFont.h"

using namespace Blast::Base;
using namespace Blast::Graphic;
using namespace Blast::Math;
using namespace Blast::Input;
using namespace Sequence::Debug;


//====================================================================================================
// Static
//----------------------------------------------------------------------------------------------------

/// TṽeLXg
const TCHAR* DebugSequenceSpriteFont::mStKPSampleTexts[] =
{
	_T("abcdefghijklmnopqrstuvwxyz"),
	_T("0123456789-+*/"),
	_T(""),
	_T("!#$%&'()=~|"),
	_T("!"),
	_T("I"),
	_T("ul̐EŁA{ɗǂv"),
	_T("ւ悤I@͏Zł푰̑AXVX̒łgbvNXI@َԌ𗬂͐񗬐ցI"),
	_T("eBVFuAvԂ˗v"),
	_T("NXu~ÃN[iE[mBAv"),
	_T("n[s[^B^ׂ̂Ȃ牽ł^т܂Bp̓̕eB[iEF[ցB"),
	_T("n[s["),
	_T("n[s"),
	_T("XC"),
	_T("~A"),
	_T("It's a Utopia !"),
};


//====================================================================================================
// Operation
//----------------------------------------------------------------------------------------------------

/// RXgN^
DebugSequenceSpriteFont::DebugSequenceSpriteFont()
	: SequenceBase(false)
	, mPFontTexture(NEW FontTexture2DDX9())
	, mPSprite(NEW SpriteDX9())
	, mPSpriteFont()
	, mPCamera2D(NEW Camera2D())
	, mPCamera3D(NEW Camera3D())
{
	mPSpriteFont.SetPointer(NEW SpriteFontDX9(_T("lr o"), 36, 500));
}

/// fXgN^
DebugSequenceSpriteFont::~DebugSequenceSpriteFont()
{
}


/// 
void DebugSequenceSpriteFont::Initialize()
{
	// ̏
	SequenceBase::Initialize();


	// fobOj[ݒ
	mPDebugMenu->GetMenuPropertyRef().mNameStr = _T("DebugSequenceSpriteFont");


	// eLXgύXpGg[Xg쐬
	SP<MenuEntryListScroll> pMEL(NEW MenuEntryListScroll());
	pMEL->GetPropertyRef().mNameStr = _T("TveLXg");

	// fobOj[ɒǉ
	mPDebugMenu->AddMenuEntryList(pMEL);


	// TṽeLXg̐Ń[v
	int sampleTextCount = sizeof(mStKPSampleTexts) / sizeof(mStKPSampleTexts[0]);
	for (int i = 0; i < sampleTextCount; ++i)
	{
		// eLXgQ
		const TCHAR* kPText = mStKPSampleTexts[i];

		// Gg[쐬
		SP<MenuEntry> pDSMEName(NEW MenuEntry());
		pDSMEName->SetText(mStKPSampleTexts[i]);

		// Gg[Xgɒǉ
		pMEL->AddMenuEntry(pDSMEName);
	}


	// FύXpGg[Xg쐬
	SP<MenuEntryListScroll> pMELColor(NEW MenuEntryListScroll());
	pMELColor->GetPropertyRef().mNameStr = _T("FύX");

	// fobOj[ɒǉ
	mPDebugMenu->AddMenuEntryList(pMELColor);


	// FGg[̖O
	const TCHAR* kPColorEntryNames[Color::mStKColorFactorCount] =
	{
		_T("R"),
		_T("G"),
		_T("B"),
		_T("A"),
	};

	// F̐Ń[v
	for (int i = 0; i < Color::mStKColorFactorCount; ++i)
	{
		// Gg[쐬
		SP< MenuEntryNumeric<float> > pMEColor(NEW MenuEntryNumeric<float>());
		pMEColor->SetText(kPColorEntryNames[i]);
		pMEColor->SetNumericPointer(&mPSpriteFont->GetColor().GetArray()[i]);
		pMEColor->SetStep(0.01f);
		pMEColor->SetLimitOver(1.0f);
		pMEColor->SetLimitUnder(0.0f);

			// Xgɒǉ
		pMELColor->AddMenuEntry(pMEColor);
	}


	// Ώۂ̕
	UINT code = 'a';


	// tHgeNX`쐬
	mPFontTexture->CreateTexture(code);


	// XvCgQ[R|[lgɒǉ
	mPGameComponents->Add(mPSprite, mPGameComponents);

	// ʒuύX
	mPSprite->Move(250, -500, 0);

	// XvCgɃeNX`ݒ
	mPSprite->SetTexture(mPFontTexture);
	mPSprite->FitTextureSize();
	mPSprite->FitTextureSourceRectangle();

	// Jݒ
	mPSprite->SetCamera(mPCamera2D);


	// XvCgtHgQ[R|[lgɒǉ
	mPGameComponents->Add(mPSpriteFont, mPGameComponents);

	// ʒuݒ
	mPSpriteFont->SetPosition(Vector3(20.0f, 400.0f, 0));

	// XvCgtHgɕݒ
	mPSpriteFont->SetText(_T("aiueo"));

	// Jݒ
	mPSpriteFont->SetCamera(mPCamera2D);


	// 2DJQ[R|[lgɒǉ
	mPGameComponents->Add(mPCamera2D, mPGameComponents);

	// 3DJQ[R|[lgɒǉ
	mPGameComponents->Add(mPCamera3D, mPGameComponents);
}

/// 
void DebugSequenceSpriteFont::HandleInput(float delta)
{
	// ̓͏
	SequenceBase::HandleInput(delta);


	// L[{[h擾
	InputManager* pIM = InputManager::GetInstance();
	IKeyboard* pKB = pIM->GetKeyboard();


	// ړx
	const float kMoveSpeed = 5.0f;

	// ړ
	Vector3 moveValue = Vector3::Zero();


	// WASD̓͂ňړʂϓ
	if (pKB->IsDown(Keys::eKEY_W))
	{
		moveValue -= Vector3::UnitY() * kMoveSpeed;
	}
	else if (pKB->IsDown(Keys::eKEY_S))
	{
		moveValue += Vector3::UnitY() * kMoveSpeed;
	}
	if (pKB->IsDown(Keys::eKEY_A))
	{
		moveValue -= Vector3::UnitX() * kMoveSpeed;
	}
	else if (pKB->IsDown(Keys::eKEY_D))
	{
		moveValue += Vector3::UnitX() * kMoveSpeed;
	}

	// ړ
	mPSpriteFont->SetPosition(mPSpriteFont->GetPosition() + moveValue);


	// EnterL[Ȃ
	if (pKB->IsJustDown(Keys::eKEY_RETURN))
	{
		// eLXgݒ
		int selectedIndex = mPDebugMenu->GetSelectedMenuEntryList()->GetSelectedIndex();
		mPSpriteFont->SetText(mStKPSampleTexts[selectedIndex]);
	}


	/* eNjbNύX */

	if (pKB->IsJustDown(Keys::eKEY_1))
	{
		mPSpriteFont->GetSprite()->GetShaderEffect()->SetTechnique(ShaderEffectDX9::eTECHNIQUE_CONSTANT);
	}
	else if (pKB->IsJustDown(Keys::eKEY_2))
	{
		mPSpriteFont->GetSprite()->GetShaderEffect()->SetTechnique(ShaderEffectDX9::eTECHNIQUE_CONSTANT_WIREFRAME);
	}
	else if (pKB->IsJustDown(Keys::eKEY_3))
	{
		mPSpriteFont->GetSprite()->GetShaderEffect()->SetTechnique(ShaderEffectDX9::eTECHNIQUE_WIREFRAME);
	}
}

/// `
void DebugSequenceSpriteFont::Render()
{
	// ̕`揈
	SequenceBase::Render();


	// ̗̈̒`
	DP(10, 500, 0xffffff00, _T("̗̈̒ = %d"), mPSpriteFont->MeasureString(mPSpriteFont->GetText()));

	// eNjbN̕ύX@
	DP(10, 550, 0xffff8888, _T("eNjbNύXł܂B\n1:Constant\n2:Constant&WireFrame\n3:WireFrame"));
}