#include "Sequence/Debug/DebugSequencePolygon.h"

#include "Blast/Graphic/DirectX9/VertexBufferDX9.h"
#include "Blast/Graphic/DirectX9/IndexBufferDX9.h"
#include "Blast/Graphic/DirectX9/VertexDeclarationDX9.h"

using namespace Sequence::Debug;
using namespace Blast::Base;
using namespace Blast::Graphic;
using namespace Blast::Math;


//====================================================================================================
// Operation
//----------------------------------------------------------------------------------------------------

/// RXgN^
DebugSequencePolygon::DebugSequencePolygon()
	: SequenceBase(false)
	, mPTriangle(NULL)
{
}

/// fXgN^
DebugSequencePolygon::~DebugSequencePolygon()
{
	SAFE_DELETE(mPTriangle);
}

/// 
void DebugSequencePolygon::Initialize()
{
	// ̏
	SequenceBase::Initialize();


	// U
	SAFE_DELETE(mPTriangle);

	// |S쐬
	mPTriangle = NEW PolygonTriangleDX9();
	mPTriangle->CreateVertexBuffer();
	mPTriangle->CreateVertexDeclaration();
	mPTriangle->CreateIndexBuffer();
	mPTriangle->CreateShaderEffect();

	// MEMO:l̓eLg[łB
	// J
	mCamera.Initialize();
	mCamera.SetPosition(Vector3::UnitZ() * -1);
	mCamera.SetEProjection(Projection::ePROJECTION_ORTHOGRAPHIC);
}

/// XV
void DebugSequencePolygon::Update(float delta)
{
	// JXV
	mCamera.Update(delta);

	// Op`|SXV
	mPTriangle->Update(delta);


	// ̍XV
	SequenceBase::Update(delta);
}

/// `
void DebugSequencePolygon::Render()
{
	// Op`|S`
	mPTriangle->SetViewProjection(mCamera.GetViewMatrixRef(), mCamera.GetProjectionMatrixRef());
	mPTriangle->Render();


#ifdef _DEBUG

	// J̏\
	mCamera.DebugRender(10, 300);

#endif // _DEBUG


	// ̕`揈
	SequenceBase::Render();
}