#include "Sequence/Debug/DebugSequenceMath.h"

using namespace Sequence::Debug;
using namespace Blast::Base;
using namespace Blast::Math;
using namespace Blast::Input;


//====================================================================================================
// Operation
//----------------------------------------------------------------------------------------------------

/// RXgN^
DebugSequenceMath::DebugSequenceMath()
	: SequenceBase(false)
{
	// V[hl
	mSeed = 1;

	// _̌ʂ
	int resultCount = sizeof(mRandomResults) / sizeof(mRandomResults[0]);
	for (int i = 0; i < resultCount; ++i)
	{
		mRandomResults[i] = 0;
	}
}

/// fXgN^
DebugSequenceMath::~DebugSequenceMath()
{
}


/// 
void DebugSequenceMath::Initialize()
{
	// ̏
	SequenceBase::Initialize();


	// ̎ނ
	mEType = eTYPE_INITIALIZE;


	// fobOj[̖Oݒ
	mPDebugMenu->GetMenuPropertyRef().mNameStr = _T("<DebugSequenceMath>");

	// j[Gg[Xgǉ
	SP<MenuEntryListScroll> pMEL(NEW MenuEntryListScroll());
	pMEL->GetPropertyRef().mNameStr = _T("<svZn>");

	mPDebugMenu->AddMenuEntryList(pMEL);


	// ̎ނύXGg[ǉ
	SP< MenuEntryNumeric<int> > pSMENumeric(NEW MenuEntryNumeric<int>());
	pSMENumeric->SetText(_T("̎"));
	pSMENumeric->SetNumericPointer(&mEType);
	pSMENumeric->SetLimitOver(eTYPE_COUNT - 1);
	pSMENumeric->SetLimitUnder(0);

	pMEL->AddMenuEntry(pSMENumeric);


	// j[Gg[Xgǉ
	SP<MenuEntryListScroll> pMELRandom(NEW MenuEntryListScroll());
	pMELRandom->GetPropertyRef().mNameStr = _T("<^>");

	mPDebugMenu->AddMenuEntryList(pMELRandom);

	// V[hGg[ǉ
	SP< MenuEntryNumeric<unsigned> > pMESeed(NEW MenuEntryNumeric<unsigned>());
	pMESeed->SetText(_T("Seed"));
	pMESeed->SetNumericPointer(&mSeed);
	pMESeed->SetLimitOver(256);
	pMESeed->SetLimitUnder(1);

	pMELRandom->AddMenuEntry(pMESeed);
}

/// 
void DebugSequenceMath::HandleInput(float delta)
{
	// ̓͏
	SequenceBase::HandleInput(delta);


	// L[{[h擾
	InputManager* pIM = InputManager::GetInstance();
	IKeyboard* pKB = pIM->GetKeyboard();

	// EnterL[ꂽ
	if (pKB->IsJustDown(Keys::eKEY_RETURN))
	{
		// IĂGg[Xg̃CfbNX擾
		int selectedListIndex = mPDebugMenu->GetMenuPropertyRef().mSelectedListIndex;

		// ԖڂȂ
		if (selectedListIndex == eENTRYLIST_RANDOM)
		{
			// _̌ʔz̐Ń[v
			int resultCount = sizeof(mRandomResults) / sizeof(mRandomResults[0]);
			for (int i = 0; i < resultCount; ++i)
			{
				// ^擾
				const int kValue = mRandom.GetNext();

				mRandomResults[i] = kValue;
			}
		}
	}
}

/// `
void DebugSequenceMath::Render()
{
	// IĂ郊XgCfbNX擾
	int selectedListIndex = mPDebugMenu->GetMenuPropertyRef().mSelectedListIndex;

	// XgCfbNXŕ
	switch (selectedListIndex)
	{
		// svZȂ
		case eENTRYLIST_MATRIX:
		{
			// \Jnʒu
			const int kPosX = 10;
			const int kPosY = 50;

			// ̎ނŃ[v
			switch (mEType)
			{
				// ]
				case eTYPE_ROTATE:				RenderRotate(kPosX, kPosY);
					break;

				// ˉe܂
				case eTYPE_WORLD_VIEW_ORTHO:	RenderWorldViewOrtho(kPosX, kPosY);
					break;

				default:
					break;
			}
		}
			break;

		// _Ȃ
		case eENTRYLIST_RANDOM:
		{
			// _̌ʂ̐Ń[v
			int resultCount = sizeof(mRandomResults) / sizeof(mRandomResults[0]);
			for (int i = 0; i < resultCount; ++i)
			{
				const int kLineHeight = 12;
				const int kEntryWidh = 100;
				const int kRowCount = 50;

				int x = (i / kRowCount) * kEntryWidh;
				int y = (i % kRowCount) * kLineHeight;

				DP(x + 50, y + 60, 0xffffffff, _T("i[%3d]=%d"), i, mRandomResults[i]);
			}
		}
			break;

		default:
			break;
	};
	

	// ̕`揈
	SequenceBase::Render();
}


//====================================================================================================
// PrivateOperation
//----------------------------------------------------------------------------------------------------

/// ]
void DebugSequenceMath::RenderRotate(int x, int y)
{
	// ẻ]p
	Vector3 rotate;
	rotate.mX = MathHelper::ToRadian(45.0f);
	rotate.mY = MathHelper::ToRadian(60.0f);
	rotate.mZ = MathHelper::ToRadian(30.0f);

	// ]s̍쐬
	Matrix rotMatX, rotMatY, rotMatZ;
	rotMatX.CreateRotationX(rotate.mX);
	rotMatY.CreateRotationY(rotate.mY);
	rotMatZ.CreateRotationZ(rotate.mZ);

	// MEMO:sxNgzȂ̂ŁAxNg*š`܂B
	// ]s̍
	Matrix rotMatZXY;
	rotMatZXY = rotMatZ * rotMatX * rotMatY;

	Matrix rotMatYXZ;
	rotMatYXZ = rotMatY * rotMatX * rotMatZ;

	// PZxNgϊ
	Vector3 zxyConverted = Vector3::UnitZ();
	zxyConverted.Multiply(rotMatZXY);

	Vector3 yxzConverted = Vector3::UnitZ();
	yxzConverted.Multiply(rotMatYXZ);


	// sCfbNX
	int lineIndex = 0;

	// o̐F
	u32 subheadColor = 0xff00ff00;

	// ʒu
	int posX = x;
	int posY = y;


	// ]p̕\
	CalculatePositionYDebugRender(posY, lineIndex, 6);
	DP(posX, posY, subheadColor, _T("]p"));

	CalculatePositionYDebugRender(posY, lineIndex, 1);
	rotate.DebugRender(posX, posY);


	// ]sX̕\
	CalculatePositionYDebugRender(posY, lineIndex, 4);
	DP(posX, posY, subheadColor, _T("]sX"));

	CalculatePositionYDebugRender(posY, lineIndex, 1);
	rotMatX.DebugRender(posX, posY);

	// ]sY̕\
	CalculatePositionYDebugRender(posY, lineIndex, 4);
	DP(posX, posY, subheadColor, _T("]sY"));

	CalculatePositionYDebugRender(posY, lineIndex, 1);
	rotMatY.DebugRender(posX, posY);

	// ]sZ̕\
	CalculatePositionYDebugRender(posY, lineIndex, 4);
	DP(posX, posY, subheadColor, _T("]sZ"));

	CalculatePositionYDebugRender(posY, lineIndex, 1);
	rotMatZ.DebugRender(posX, posY);


	// ]sZXY̕\
	CalculatePositionYDebugRender(posY, lineIndex, 6);
	DP(posX, posY, subheadColor, _T("]sZXY"));

	CalculatePositionYDebugRender(posY, lineIndex, 1);
	rotMatZXY.DebugRender(posX, posY);

	// ]sZXY̌ʂ\
	CalculatePositionYDebugRender(posY, lineIndex, 4);
	DP(posX, posY, subheadColor, _T("jbgZ̉]sZXY"));

	CalculatePositionYDebugRender(posY, lineIndex, 1);
	zxyConverted.DebugRender(posX, posY);


	// ]sYXZ̕\
	CalculatePositionYDebugRender(posY, lineIndex, 3);
	DP(posX, posY, subheadColor, _T("]sYXZ"));

	CalculatePositionYDebugRender(posY, lineIndex, 1);
	rotMatYXZ.DebugRender(posX, posY);

	// ]sYXŽʂ\
	CalculatePositionYDebugRender(posY, lineIndex, 4);
	DP(posX, posY, subheadColor, _T("jbgZ̉]syxz"));

	CalculatePositionYDebugRender(posY, lineIndex, 1);
	yxzConverted.DebugRender(posX, posY);
}

/// ˉeϊ܂ł̏
void DebugSequenceMath::RenderWorldViewOrtho(int x, int y)
{
	// [hs쐬
	Matrix world;
	world.Identity();


	// J̈ʒu
	Vector3 eyePos = Vector3::UnitZ() * -25;

	// _
	Vector3 lookAt = Vector3::UnitZ();

	// r[s
	Matrix view;
	view.CreateViewLH(eyePos, lookAt, Vector3::UnitY());


	// ˉes
	Matrix ortho;
	ortho.CreateOrthoGraphicLH(1024, 768, -1000.0f, 1000.0f);


	// [|Cgϊ
	Vector3 zeroPointW = Vector3::Zero();
	zeroPointW.Multiply(world);

	Vector3 zeroPointWV = zeroPointW;
	zeroPointWV.Multiply(view);

	Vector3 zeroPointWVP = zeroPointWV;
	zeroPointWVP.Multiply(ortho);


	// XxNgϊ
	const float xVectorLengt = 100.0f;

	Vector3 xVectorW = Vector3::UnitX() * xVectorLengt;
	xVectorW.Multiply(world);

	Vector3 xVectorWV = xVectorW;
	xVectorWV.Multiply(view);

	Vector3 xVectorWVP = xVectorWV;
	xVectorWVP.Multiply(ortho);


	// o̐F
	u32 subheadColor = 0xff00ff00;

	// sCfbNX
	int lineIndex = 0;

	// ʒu
	int posX = x;
	int posY = y;


	// [hs\
	CalculatePositionYDebugRender(posY, lineIndex, 0);
	DP(posX, y + posY, subheadColor, _T("[hs"));

	CalculatePositionYDebugRender(posY, lineIndex, 1);
	world.DebugRender(posX, y + posY);


	// J̈ʒu\
	CalculatePositionYDebugRender(posY, lineIndex, 5);
	DP(posX, y + posY, subheadColor, _T("J̈ʒu"));

	CalculatePositionYDebugRender(posY, lineIndex, 1);
	eyePos.DebugRender(posX, y + posY);

	// _\
	CalculatePositionYDebugRender(posY, lineIndex, 1);
	DP(posX, y + posY, subheadColor, _T("_"));

	CalculatePositionYDebugRender(posY, lineIndex, 1);
	lookAt.DebugRender(posX, y + posY);


	// r[s\
	CalculatePositionYDebugRender(posY, lineIndex, 2);
	DP(posX, y + posY, subheadColor, _T("r[s"));

	CalculatePositionYDebugRender(posY, lineIndex, 1);
	view.DebugRender(posX, y + posY);


	// ˉes\
	CalculatePositionYDebugRender(posY, lineIndex, 5);
	DP(posX, y + posY, subheadColor, _T("ˉes"));

	CalculatePositionYDebugRender(posY, lineIndex, 1);
	ortho.DebugRender(posX, y + posY);


	// [|Cgϊ\
	CalculatePositionYDebugRender(posY, lineIndex, 5);
	DP(posX, y + posY, subheadColor, _T("[|CgWϊ"));
	
	CalculatePositionYDebugRender(posY, lineIndex, 1);
	zeroPointW.DebugRender(posX, y + posY);


	CalculatePositionYDebugRender(posY, lineIndex, 2);
	DP(posX, y + posY, subheadColor, _T("[|CgWVϊ"));

	CalculatePositionYDebugRender(posY, lineIndex, 1);
	zeroPointWV.DebugRender(posX, y + posY);


	CalculatePositionYDebugRender(posY, lineIndex, 2);
	DP(posX, y + posY, subheadColor, _T("[|CgWVPϊ"));

	CalculatePositionYDebugRender(posY, lineIndex, 1);
	zeroPointWVP.DebugRender(posX, y + posY);


	// XxNgϊ\
	CalculatePositionYDebugRender(posY, lineIndex, 3);
	DP(posX, y + posY, subheadColor, _T("XxNgWϊ"));
	
	CalculatePositionYDebugRender(posY, lineIndex, 1);
	xVectorW.DebugRender(posX, y + posY);


	CalculatePositionYDebugRender(posY, lineIndex, 2);
	DP(posX, y + posY, subheadColor, _T("XxNgWVϊ"));

	CalculatePositionYDebugRender(posY, lineIndex, 1);
	xVectorWV.DebugRender(posX, y + posY);


	CalculatePositionYDebugRender(posY, lineIndex, 2);
	DP(posX, y + posY, subheadColor, _T("XxNgWVPϊ"));

	CalculatePositionYDebugRender(posY, lineIndex, 1);
	xVectorWVP.DebugRender(posX, y + posY);
}

/// \ʒuY̎Zo
void DebugSequenceMath::CalculatePositionYDebugRender(int& rOutY, int& rLineIndex, int addLineIndex)
{
	// s
	const int kLineSpacing = 12;

	// CfbNXi߂
	rLineIndex += addLineIndex;

	// ʒuZo
	rOutY = kLineSpacing * rLineIndex;
}