#include "Sequence/Debug/DebugSequenceLine.h"

#include "Blast/Math/MathHelper.h"


using namespace Sequence::Debug;
using namespace Blast::Base;
using namespace Blast::Graphic;
using namespace Blast::Math;
using namespace Blast::Input;


//====================================================================================================
// Operation
//----------------------------------------------------------------------------------------------------

/// RXgN^
DebugSequenceLine::DebugSequenceLine()
	: SequenceBase(false)
{
	// C3D쐬
	mPLine3D.SetPointer(NEW Line3DDX9());

	// XYZ쐬
	mPXYZAxis.SetPointer(NEW XYZAxisDX9());

	// C2D쐬
	mPLine2D.SetPointer(NEW Line2DDX9());


	// J쐬
	mPCamera.SetPointer(NEW Camera3D());
}

/// fXgN^
DebugSequenceLine::~DebugSequenceLine()
{
}


/// 
void DebugSequenceLine::Initialize()
{
	// ̏
	SequenceBase::Initialize();


	// fobOj[̖Oݒ
	mPDebugMenu->GetMenuPropertyRef().mNameStr = _T("<DebugSequenceLine>");

	// Gg[Xg쐬AfobOj[ɒǉ
	SP<MenuEntryListScroll> pMEL(NEW MenuEntryListScroll());
	pMEL->GetPropertyRef().mNameStr = _T("<Line3D>");

	mPDebugMenu->AddMenuEntryList(pMEL);


	// Vector3̗vfŃ[v
	for (int i = 0; i < 3; ++i)
	{
		// C3D̊Jn_Gg[ǉ
		SP< MenuEntryNumeric<float> > pMELine3DStart(NEW MenuEntryNumeric<float>());
		pMELine3DStart->SetText(_T("C3D̊Jn_"));

		pMELine3DStart->SetNumericPointer(&mLine3DStart.m[i]);

		pMEL->AddMenuEntry(pMELine3DStart);
	}

	// Vector3̗vfŃ[v
	for (int i = 0; i < 3; ++i)
	{
		// C3D̏I_Gg[ǉ
		SP< MenuEntryNumeric<float> > pMELine3DEnd(NEW MenuEntryNumeric<float>());
		pMELine3DEnd->SetText(_T("C3D̏I_"));
		pMELine3DEnd->SetNumericPointer(&mLine3DEnd[i]);

		pMEL->AddMenuEntry(pMELine3DEnd);
	}


	// XYZ̒Gg[ǉ
	SP< MenuEntryNumeric<float> > pMEXYZLength(NEW MenuEntryNumeric<float>());
	pMEXYZLength->SetText(_T("XYZ̒"));
	pMEXYZLength->SetNumericPointer(&mPXYZAxis->GetLengthRef());
	pMEXYZLength->SetStep(1);

	pMEL->AddMenuEntry(pMEXYZLength);


	// Vector2̗vfŃ[v
	for (int i = 0; i < 2; ++i)
	{
		// C2D̊Jn_Gg[ǉ
		SP< MenuEntryNumeric<float> > pMELine2DStart(NEW MenuEntryNumeric<float>());
		pMELine2DStart->SetText(_T("C2D̊Jn_"));
		pMELine2DStart->SetNumericPointer(&mLine2DStart[i]);

		pMEL->AddMenuEntry(pMELine2DStart);
	}

	// Vector2̗vfŃ[v
	for (int i = 0; i < 2; ++i)
	{
		// C2D̏I_Gg[ǉ
		SP< MenuEntryNumeric<float> > pMELine2DEnd(NEW MenuEntryNumeric<float>());
		pMELine2DEnd->SetText(_T("C2D̏I_"));
		pMELine2DEnd->SetNumericPointer(&mLine2DEnd[i]);

		pMEL->AddMenuEntry(pMELine2DEnd);
	}

	// C2D̑
	SP< MenuEntryNumeric<float> > pSMELine2DWidth(NEW MenuEntryNumeric<float>);
	pSMELine2DWidth->SetText(_T("C2D̑"));
	pSMELine2DWidth->SetNumericPointer(&mPLine2D->GetLine2DDX9PropertyRef().mWidth);

	pMEL->AddMenuEntry(pSMELine2DWidth);


	// C3D̊Jn_ݒ
	mLine3DStart = Vector3::Zero();

	// C3D̏I_ݒ
	mLine3DEnd = Vector3(5, 10, 5);

	// C3D̐Fݒ
	mPLine3D->GetLine3DDX9PropertyRef().mColor = 0xffffff00;

	// C3DɃJݒ
	mPLine3D->SetCamera(mPCamera);


	// C2D̊Jn_ݒ
	mLine2DStart = Vector2(500, 500);

	// C2D̏I_ݒ
	mLine2DEnd = Vector2(600, 550);


	// XYZɃJݒ
	mPXYZAxis->SetCamera(mPCamera);

	// XYZ̒ݒ
	mPXYZAxis->SetLength(200.0f);

	// XYZQ[R|[lgɒǉ
	mPGameComponents->Add(mPXYZAxis, mPGameComponents);


	// J
	mPCamera->Initialize();
	mPCamera->SetPosition(Vector3(1, 1, -1) * 20);

	// JQ[R|[lgɒǉ
	mPGameComponents->Add(mPCamera, mPGameComponents);
}

/// 
void DebugSequenceLine::HandleInput(float delta)
{
	// ̓͏
	SequenceBase::HandleInput(delta);


	// L[{[h擾
	InputManager* pIM = InputManager::GetInstance();
	IKeyboard* pKB = pIM->GetKeyboard();

	// ʒu̕ϓ
	float speed = 0.5f;
	Vector3 moveValue = 0;

	// WL[ĂȂ
	if (pKB->IsDown(Keys::eKEY_W))
	{
		moveValue.mY = 1 * speed;
	}
	// SL[ĂȂ
	else if (pKB->IsDown(Keys::eKEY_S))
	{
		moveValue.mY = -1 * speed;
	}

	// AL[ĂȂ
	if (pKB->IsDown(Keys::eKEY_A))
	{
		moveValue.mX = -1 * speed;
	}
	else if (pKB->IsDown(Keys::eKEY_D))
	{
		moveValue.mX = 1 * speed;
	}

	// ʒuϓ
	mLine3DEnd += moveValue;
}

/// XV
void DebugSequenceLine::Update(float delta)
{
	// C3DXV
	mPLine3D->Update(delta);


	// JXV
	mPCamera->Update(delta);


	// ̍XV
	SequenceBase::Update(delta);
}

/// `
void DebugSequenceLine::Render()
{
	// C3D̓_z
	Vector3 line3DPoints[] =
	{
		mLine3DStart,
		mLine3DEnd,
	};

	// C3D̓_̐
	int line3DPointCount = sizeof(line3DPoints) / sizeof(line3DPoints[0]);

	// C3D`
	mPLine3D->SetCamera(mPCamera);
	mPLine3D->Render(line3DPoints, line3DPointCount);


	// C2D̓_z
	Vector2 line2DPoints[] =
	{
		mLine2DStart,
		mLine2DEnd,
	};

	// C2D̓_̐
	int line2DPointCount = sizeof(line2DPoints) / sizeof(line2DPoints[0]);

	// C2D`
	mPLine2D->Render(line2DPoints, line2DPointCount);
	

	// ̕`揈
	SequenceBase::Render();
}