#include "Sequence/Debug/DebugSequenceInput.h"

#include "Sequence/Debug/Input/DebugSequenceInputKeyboard.h"
#include "Sequence/Debug/Input/DebugSequenceInputMouse.h"
#include "Sequence/Debug/Input/DebugSequenceInputJoystick.h"

using namespace Blast::Base;
using namespace Blast::Input;
using namespace Sequence::Debug;
using namespace Sequence::Debug::Input;


//====================================================================================================
// Operation
//----------------------------------------------------------------------------------------------------

/// RXgN^
DebugSequenceInput::DebugSequenceInput()
	: SequenceBase(false)
{
}

/// fXgN^
DebugSequenceInput::~DebugSequenceInput()
{
}


/// 
void DebugSequenceInput::Initialize()
{
	// ̏
	SequenceBase::Initialize();


	// fobOj[̖Oݒ
	mPDebugMenu->GetMenuPropertyRef().mNameStr = _T("<DebugSequenceInput>");

	
	// jGg[Xgǉ
	SP<MenuEntryListScroll> pMEL(NEW MenuEntryListScroll());
	pMEL->GetPropertyRef().mNameStr = _T("<@\>");

	mPDebugMenu->AddMenuEntryList(pMEL);


	// j[Gg[̖Op
	const TCHAR* kPEntryNames[] =
	{
		_T("L[{[h"),
		_T("}EX"),
		_T("WCXeBbN"),
	};

	int entryNameCount = sizeof(kPEntryNames) / sizeof(kPEntryNames[0]);


	// j[Gg[̖O̐Ń[v
	for (int i = 0; i < entryNameCount; ++i)
	{
		// j[Gg[ǉ
		SP<MenuEntry> pSMEName(NEW MenuEntry());
		pSMEName->SetText(kPEntryNames[i]);

		// Xgɒǉ
		pMEL->AddMenuEntry(pSMEName);
	}
}

/// 
void DebugSequenceInput::HandleInput(float delta)
{
	// ̓͏
	SequenceBase::HandleInput(delta);


	// j[Gg[̑I菈
	HandleInputMenuEntries(delta);
}


//====================================================================================================
// PrivateOperation
//----------------------------------------------------------------------------------------------------

/// j[Gg[̑I菈
void DebugSequenceInput::HandleInputMenuEntries(float delta)
{
	// L[{[h擾
	InputManager* pIM = InputManager::GetInstance();
	IKeyboard* pKB = pIM->GetKeyboard();

	// EnterL[ꂽȂ
	if (pKB->IsJustDown(Keys::eKEY_RETURN))
	{
		// IĂGg[̃CfbNXŕ
		int selectedIndex = mPDebugMenu->GetSelectedMenuEntryList()->GetSelectedIndex();
		switch (selectedIndex)
		{
			/// L[{[hȂ
			case eMENU_ENTRY_KEYBOARD:
				AddSequence(NEW DebugSequenceInputKeyboard());
				break;

			/// }EXȂ
			case eMENU_ENTRY_MOUSE:
				AddSequence(NEW DebugSequenceInputMouse());
				break;

			/// WCXeBbNȂ
			case eMENU_ENTRY_JOYSTICK:
				AddSequence(NEW DebugSequenceInputJoystick());
				break;

			/// P[XOȂ
			default:
				break;
		}
	}
}

/// V[PXǉ
void DebugSequenceInput::AddSequence(ISequence* pSequence)
{
	// V[PX}l[W[Q
	SequenceManager* pSM = SequenceManager::GetInstance();

	// V[PXǉ
	SP<ISequence> spSequence;
	spSequence.SetPointer(pSequence);

	pSM->AddSequence(spSequence);
}