#include "Sequence/Debug/DebugSequenceFPSCounter.h"

#include "Blast/Base/FPSCounter.h"

using namespace Blast::Base;
using namespace Sequence::Debug;


//====================================================================================================
// Operation
//----------------------------------------------------------------------------------------------------

/// RXgN^
DebugSequenceFPSCounter::DebugSequenceFPSCounter()
	: SequenceBase(false)
	, mPFPSCounter(NULL)
{
	// FPSJE^쐬
	mPFPSCounter = NEW FPSCounter();
}

/// fXgN^
DebugSequenceFPSCounter::~DebugSequenceFPSCounter()
{
	// FPSJE^
	SAFE_DELETE(mPFPSCounter);
}

/// `
void DebugSequenceFPSCounter::Render()
{
	// FPSJE^̒l擾
	double fps = mPFPSCounter->GetFPS();


	// ʒu
	int x = 0;
	int y = 0;

	// sCfbNX
	int lineIndex = 0;

	// s
	const int kLineSpacing = 15;


	// V[PX̐
	y = kLineSpacing * lineIndex++;
	DP(x, y, 0xffffff00, _T("FPSv̋mF܂B"));

	// FPS̒l`
	lineIndex++;
	y = kLineSpacing * lineIndex++;
	DP(x, y, 0xffffffff, _T("FPS:%lf"), fps);
}