#include "Possession.h"

#include <algorithm>
#include "ItemDatabase.h"

#include "ItemTag.h"

using namespace Blast::Graphic;


//====================================================================================================
// Operation
//----------------------------------------------------------------------------------------------------

/// RXgN^
Possession::Possession()
{
}

/// fXgN^
Possession::~Possession()
{
}


/// lAiɉ
void Possession::Obtain(int id)
{
	SItem sItem;
	sItem.mID = id;
	sItem.mEItemTag = static_cast<ItemTag::EItemTag>(id);

	mItems.push_back(sItem);

#if _DEBUG
	// _vƕ₷
	ItemDatabase* pIDB = ItemDatabase::GetInstance();
	PFL(_T("ACe擾 ID=%d, O=%s"), id, pIDB->GetCatalogAt(id)->mName);
#endif // _DEBUG
}

/// pAi猸炷
void Possession::Discard(int id)
{
	PFL(_T("ID\"%d\"j܂B"), id);

	// HACK:
	ItemList::iterator it;
	for (it = mItems.begin(); it != mItems.end(); ++it)
	{
		// 폜
		if ( (*it).mID == id )
		{
			mItems.erase(it);

			return;
		}
	}

	WARNING(NULL, _T("ID܂BID=%dB"), id);
}

/// 
void Possession::Alignment()
{
	// TODO:B\̂ɂ̂ŃvfBP[gȂ蓮ȂpӂȂƃ_B
	//mItems.sort();
}

/// CfbNX擾BconsttB
const Possession::SItem* Possession::GetItemAt(int index) const
{
	bool isInRange = (0 <= index && index < (int)mItems.size());
	ASSERT_PF(isInRange, _T("CfbNX͈͊OłB\nindex=%d"), index);
	if (isInRange)
	{
		ItemList::const_iterator kIt = mItems.begin();
		std::advance(kIt, index);

		return &(*kIt);
	}

	return NULL;
}

/// CfbNX擾
Possession::SItem* Possession::GetItemAt(int index)
{
	// MEMO:łg邱ƂɂȂ邾낤A߂Ďgp̂͂Ȃ̂łɃB
	// ̃|C^constt邱ƂŌĂяoo֐const̂̂ɂA
	// ŌconstOƂœ̏ۂĂB
	// Ȃ胁o֐ĂłAƔf̂ŔɊ댯B
	// const_castB̃`XȂB
	return const_cast<SItem*>( static_cast<const Possession*>(this)->GetItemAt(index) );
}

/// ̏擾
int Possession::GetItemCount() const
{
	return mItems.size();
}

/// Ă邩ǂ擾
bool Possession::IsExist(ItemTag::EItemTag eTag) const
{
	ItemList::const_iterator kIt;
	for (kIt = mItems.begin(); kIt != mItems.end(); ++kIt)
	{
		if ( (*kIt).mEItemTag == eTag )
		{
			return true;
		}
	}

	return false;
}

/// ĂȂǂ擾
bool Possession::IsEmpty() const
{
	return mItems.empty();
}


//====================================================================================================
// Property
//----------------------------------------------------------------------------------------------------

/// ̃Xg擾BconsttB
const Possession::ItemList& Possession::GetItems() const
{
	return mItems;
}

/// ̃Xg擾
Possession::ItemList& Possession::GetItems()
{
	return mItems;
}
