#include "NextFloorTile.h"

using namespace Blast::Math;
using namespace Blast::Graphic;


//====================================================================================================
// Operation
//----------------------------------------------------------------------------------------------------

/// RXgN^
NextFloorTile::NextFloorTile()
	: mPModel(NEW StaticModelDX9())
	, mPCrosshair(NEW CrosshairDX9())
{
	// NXwA쐬
	mPCrosshair->Create(50);
}

/// fXgN^
NextFloorTile::~NextFloorTile()
{
}


/// XV
void NextFloorTile::Update(float delta)
{
	// fXV
	if (mPModel)
	{
		// ROGUISH:Y]
		float radY = MathHelper::ToRadian(360.0f * delta);
		mPModel->Rotate(Vector3::UnitY() * radY);

		mPModel->Update(delta);
	}

	// NXwAXV
	if (mPCrosshair)
	{
		mPCrosshair->Update(delta);
	}
}

/// `
void NextFloorTile::Render()
{
	// f`
	if (mPModel)
	{
		mPModel->SetCamera(mPCamera);
		mPModel->Render();
	}

	// NXwA
	if (mPCrosshair)
	{
		mPCrosshair->SetCamera(mPCamera);
		mPCrosshair->Render();
	}
}


/// f̓ǂݍ
void NextFloorTile::LoadModel(const TCHAR* const kPFullPath)
{
	mPModel->LoadMesh(kPFullPath);
}