#ifndef MESSAGETEXT_H
#define MESSAGETEXT_H

#include <vector>
#include "Blast/Graphic/IFont.h"
#include "Blast/Graphic/ICamera.h"


/// bZ[WEBhEɕ\eLXgSNX
class MessageText
{
public:
	//====================================================================================================
	// Struct
	//----------------------------------------------------------------------------------------------------

	/// eLXg̏\
	struct SText
	{
	public:
		/// \
		enum EState
		{
			/// \
			eSTATE_HIDE,

			/// 
			eSTATE_ENTER,

			/// \
			eSTATE_SHOW,

			/// ޏ
			eSTATE_LEAVE,

			/// I
			eSTATE_EXIT,


			/// 񋓗vf̐
			eSTATE_COUNT,
		};


		/// RXgN^
		SText();

		/// XV
		void Update(float);

		/// `
		void Render(SP<Blast::Graphic::IFont>);


		/// wʒuɎw莞ԂĈړ
		void Move(const Blast::Math::Vector3& kRTargetPosition, float time);


		/// \Ԃ擾
		EState GetState() const;

		/// \Ԃݒ
		void SetState(EState);


		/// Iėǂǂ擾
		bool IsExit() const;


		/// 
		tstring mTextStr;

		/// ʒu
		Blast::Math::Vector3 mPosition;

		/// ړ̖ڕWʒu
		Blast::Math::Vector3 mMoveTargetPosition;
		
		/// ړ̎c莞
		float mMoveLeftTime;

		
		/// \
		EState mEState;
	};


	//====================================================================================================
	// Operation
	//----------------------------------------------------------------------------------------------------

	/// RXgN^
	MessageText();

	/// fXgN^
	~MessageText();


	/// tHgݒ
	void SetFont(const SP<Blast::Graphic::IFont>);


	/// XV
	void Update(float);

	/// `
	void Render();


	/// ǉ
	void AddText(const TCHAR* const);

	/// ̕\
	void NextText(float lifeTime, float moveTime);

	
	//====================================================================================================
	// Transfar
	//----------------------------------------------------------------------------------------------------

	/// Jݒ
	void SetCamera(const SP<Blast::Graphic::ICamera>);

	/// ʒuݒ
	void SetPosition(const Blast::Math::Vector3&);

	/// ݒ
	void SetText(const TCHAR* const);

private:
	/// tHg
	SP<Blast::Graphic::IFont> mPFont;

	/// eLXg
	std::vector<SText> mSTexts;
};

#endif // MESSAGETEXT_H