#include "MapDataManager.h"


//====================================================================================================
// Static
//----------------------------------------------------------------------------------------------------

// ɂ͖{CSVǂݍ܂

/// `bvQ
static const MapDataManager::SChipData nKChipDatas[] =
{
	{ ChipTag::eCHIP_LAND_0,	ChipKindTag::eCHIP_KIND_LAND,	_T("./Res/Model/Tile/Tile_0/Mesh.FBX") },
	{ ChipTag::eCHIP_LAND_1,	ChipKindTag::eCHIP_KIND_LAND,	_T("./Res/Model/Tile/Tile_0/Mesh.FBX") },
	{ ChipTag::eCHIP_LAND_2,	ChipKindTag::eCHIP_KIND_LAND,	_T("./Res/Model/Tile/Tile_0/Mesh.FBX") },
	{ ChipTag::eCHIP_WATER_0,	ChipKindTag::eCHIP_KIND_WATER,	_T("./Res/Model/Tile/Tile_1/Mesh.FBX") },
	{ ChipTag::eCHIP_WATER_1,	ChipKindTag::eCHIP_KIND_WATER,	_T("./Res/Model/Tile/Tile_1/Mesh.FBX") },
	{ ChipTag::eCHIP_WATER_2,	ChipKindTag::eCHIP_KIND_WATER,	_T("./Res/Model/Tile/Tile_1/Mesh.FBX") },
	{ ChipTag::eCHIP_AIR_0,		ChipKindTag::eCHIP_KIND_AIR,	_T("./Res/Model/Tile/Tile_2/Mesh.FBX") },
	{ ChipTag::eCHIP_AIR_1,		ChipKindTag::eCHIP_KIND_AIR,	_T("./Res/Model/Tile/Tile_2/Mesh.FBX") },
	{ ChipTag::eCHIP_AIR_2,		ChipKindTag::eCHIP_KIND_AIR,	_T("./Res/Model/Tile/Tile_2/Mesh.FBX") },
	{ ChipTag::eCHIP_WALL_0,	ChipKindTag::eCHIP_KIND_WALL,	_T("./Res/Model/Wall/Wall_0/Mesh.FBX") },
	{ ChipTag::eCHIP_WALL_1,	ChipKindTag::eCHIP_KIND_WALL,	_T("./Res/Model/Wall/Wall_0/Mesh.FBX") },
	{ ChipTag::eCHIP_WALL_2,	ChipKindTag::eCHIP_KIND_WALL,	_T("./Res/Model/Wall/Wall_0/Mesh.FBX") },
};

/// `bv̐
static const int nKChipDataCount = SIZE_OF_ARRAY(nKChipDatas);


/// `bvZbgQ
static const MapDataManager::SChipsetData nKSChipsetDatas[] =
{
	{ ChipsetTag::eCHIPSET_GLASSLAND,	{ ChipTag::eCHIP_LAND_0, ChipTag::eCHIP_WATER_0, ChipTag::eCHIP_AIR_0, ChipTag::eCHIP_WALL_0, }, },
	{ ChipsetTag::eCHIPSET_CAVE,		{ ChipTag::eCHIP_WALL_0, ChipTag::eCHIP_AIR_0, ChipTag::eCHIP_AIR_0, ChipTag::eCHIP_AIR_0, }, },
	{ ChipsetTag::eCHIPSET_GRAVEYARD,	{ ChipTag::eCHIP_WALL_0, ChipTag::eCHIP_LAND_0, ChipTag::eCHIP_LAND_0, ChipTag::eCHIP_LAND_0, }, },
	{ ChipsetTag::eCHIPSET_FOREST,		{ ChipTag::eCHIP_LAND_0, ChipTag::eCHIP_AIR_0, ChipTag::eCHIP_AIR_0, ChipTag::eCHIP_AIR_0, }, },
	{ ChipsetTag::eCHIPSET_MOUTAIN,		{ ChipTag::eCHIP_LAND_0, ChipTag::eCHIP_LAND_0, ChipTag::eCHIP_AIR_0, ChipTag::eCHIP_AIR_0, }, },
	{ ChipsetTag::eCHIPSET_VALLEY,		{ ChipTag::eCHIP_LAND_0, ChipTag::eCHIP_LAND_0, ChipTag::eCHIP_AIR_0, ChipTag::eCHIP_AIR_0, }, },
};

/// `bvZbg̐
static const int nKChipsetDataCount = SIZE_OF_ARRAY(nKSChipsetDatas);


/// tAQ
static const MapDataManager::SFloorPlacementData nKSFloorPlacementDatas[] =
{
	{ TerrainTag::eTERRAIN_GLASSLAND_00, ChipsetTag::eCHIPSET_GLASSLAND, { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 } },
	{ TerrainTag::eTERRAIN_GLASSLAND_01, ChipsetTag::eCHIPSET_GLASSLAND, { 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 3, 3, 3 } },
	{ TerrainTag::eTERRAIN_GLASSLAND_02, ChipsetTag::eCHIPSET_GLASSLAND, { 0, 1, 2, 3, 0, 1, 2, 3, 0, 1, 2, 3, 0, 1, 2, 3 } },
	{ TerrainTag::eTERRAIN_FOREST_00, ChipsetTag::eCHIPSET_FOREST, { 3, 2, 0, 1, 1, 2, 2, 3, 0, 3 } },
	{ TerrainTag::eTERRAIN_FOREST_01, ChipsetTag::eCHIPSET_FOREST, { 3, 2, 0, 1, 1, 2, 2, 3, 0, 3 } },
	{ TerrainTag::eTERRAIN_FOREST_02, ChipsetTag::eCHIPSET_FOREST, { 3, 2, 0, 1, 1, 2, 2, 3, 0, 3 } },
};

/// tA̐
static const int nKFloorPlacementDataCount = SIZE_OF_ARRAY(nKSFloorPlacementDatas);


/// G̃`bvQ
static const MapDataManager::SEnemyChipData nKSEnemyChipDatas[] =
{
	{ EnemyChipTag::eCHIP_0, _T("./Res/Model/Characters/102_IzayoiSakuya/002_Skin.FBX"), },
	{ EnemyChipTag::eCHIP_1, _T("./Res/Model/Characters/102_IzayoiSakuya/002_Skin.FBX"), },
	{ EnemyChipTag::eCHIP_2, _T("./Res/Model/Characters/102_IzayoiSakuya/002_Skin.FBX"), },
};
/// G̃`bv̐
static const int nKEnmeyChipDataCount = SIZE_OF_ARRAY(nKSEnemyChipDatas);

/// G̃`bvZbgQ
static const MapDataManager::SEnemyChipsetData nKSEnemyChipsetDatas[] =
{
	{ EnemyChipsetTag::eCHIPSET_0, { EnemyChipTag::eCHIP_0, EnemyChipTag::eCHIP_1, EnemyChipTag::eCHIP_2, }, },
	{ EnemyChipsetTag::eCHIPSET_1, { EnemyChipTag::eCHIP_0, EnemyChipTag::eCHIP_0, EnemyChipTag::eCHIP_0, }, },
	{ EnemyChipsetTag::eCHIPSET_2, { EnemyChipTag::eCHIP_1, EnemyChipTag::eCHIP_1, EnemyChipTag::eCHIP_2, }, },
};
/// G̃`bvZbg̐
static const int nKEnmeyChipsetDataCount = SIZE_OF_ARRAY(nKSEnemyChipsetDatas);


//====================================================================================================
// Operation
//----------------------------------------------------------------------------------------------------

/// RXgN^
MapDataManager::MapDataManager()
{
}

/// fXgN^
MapDataManager::~MapDataManager()
{
}


/// `bv擾
const MapDataManager::SChipData& MapDataManager::GetChipData(ChipTag::EChipTag eTag) const
{
	return nKChipDatas[eTag];
}


/// `bvZbg擾
const MapDataManager::SChipsetData& MapDataManager::GetChipsetData(ChipsetTag::EChipsetTag eTag) const
{
	return nKSChipsetDatas[eTag];
}

/// tA擾
const MapDataManager::SFloorPlacementData& MapDataManager::GetFloorPlacementData(TerrainTag::ETerrainTag eTag) const
{
	return nKSFloorPlacementDatas[eTag];
}

/// G̃`bv擾
const MapDataManager::SEnemyChipData& MapDataManager::GetEnemyChipData(EnemyChipTag::EChipTag eEnemyChipTag) const
{
	return nKSEnemyChipDatas[eEnemyChipTag];
}

/// G̃`bvZbg擾
const MapDataManager::SEnemyChipsetData& MapDataManager::GetEnemyChipsetData(EnemyChipsetTag::EChipsetTag eEnemyChipsetTag) const
{
	return nKSEnemyChipsetDatas[eEnemyChipsetTag];
}