#include "MainMenuStateItem.h"

#include "Blast/Input/PadInputTag.h"
#include "./Sequence/MainMenuSequence.h"
#include "MainMenuStateController.h"

using namespace Blast::Frontend;


//====================================================================================================
// Operation
//----------------------------------------------------------------------------------------------------

/// RXgN^
MainMenuStateItem::MainMenuStateItem(MainMenuStateController* pStateController)
	: mPStateController(pStateController)
{
	// j[
	GetDataManager()->GetFEItem()->SetHandleInput(true);
	GetDataManager()->GetFEItem()->SetVisible(true);
}

/// fXgN^
MainMenuStateItem::~MainMenuStateItem()
{
}

/// 
void MainMenuStateItem::HandleInput(float delta)
{
	// UNDONE:j[̓͌ʂŏ𕪊
	SP<FEMenu> pMenu = GetDataManager()->GetFEItem()->GetMenu();
	PadInputTag::EPadInputTag eResult = pMenu->GetInputResultTag();
	switch (eResult)
	{
		// 
		case PadInputTag::eINPUT_RESULT_DECIDE:
		{
			// 

			// sI֑J
			GetDataManager()->GetFEItem()->SetHandleInput(false);
			mPStateController->ChangeState(MainMenuStateController::eSTATE_CONDUCT);
		}
			break;

		// 
		case PadInputTag::eINPUT_RESULT_CANCEL:
			// gbv֑J
			GetDataManager()->GetFEItem()->SetHandleInput(false);
			GetDataManager()->GetFEItem()->SetVisible(false);
			mPStateController->ChangeState(MainMenuStateController::eSTATE_TOP);
			break;

		// I
		case PadInputTag::eINPUT_RESULT_SELECT:
			break;

		// ̑
		default:
			break;
	}
}

/// XV
void MainMenuStateItem::Update(float delta)
{
}

/// `
void MainMenuStateItem::Render()
{
	DP(10, 10, 0xffffffff, _T("MainMenuStateItemB"));
}


//====================================================================================================
// Implement
//----------------------------------------------------------------------------------------------------

/// Ǘ擾
SP<MainMenuDataManager> MainMenuStateItem::GetDataManager()
{
	return mPStateController->GetSequence()->GetDataManager();
}