#include "MainMenuStateConduct.h"

#include "Blast/Input/PadInputTag.h"
#include "./Sequence/MainMenuSequence.h"
#include "MainMenuStateController.h"

#include "ItemCommandTag.h"

using namespace Blast::Frontend;


//====================================================================================================
// Operation
//----------------------------------------------------------------------------------------------------

/// RXgN^
MainMenuStateConduct::MainMenuStateConduct(MainMenuStateController* pStateController)
	: mPStateController(pStateController)
{
	// tgGh
	GetDataManager()->GetFEConduct()->SetHandleInput(true);
	GetDataManager()->GetFEConduct()->SetVisible(true);

	// \R}hݒ肷
	GetDataManager()->GetFEConduct()->SetItem( GetDataManager()->GetFEItem()->GetSelectedItemTag() );
}

/// fXgN^
MainMenuStateConduct::~MainMenuStateConduct()
{
}

/// 
void MainMenuStateConduct::HandleInput(float delta)
{
	// UNDONE:j[̓͌ʂŏ𕪊
	SP<FEMenu> pMenu = GetDataManager()->GetFEConduct()->GetMenu();
	PadInputTag::EPadInputTag eResult = pMenu->GetInputResultTag();
	switch (eResult)
	{
		// 
		case PadInputTag::eINPUT_RESULT_DECIDE:
			DecidedMenuItem();
			break;

		// 
		case PadInputTag::eINPUT_RESULT_CANCEL:
			GetDataManager()->GetFEConduct()->HandleInput(false);
			GetDataManager()->GetFEConduct()->SetVisible(false);
			mPStateController->ChangeState(MainMenuStateController::eSTATE_ITEM);
			break;

		// I
		case PadInputTag::eINPUT_RESULT_SELECT:
			break;

		// ̑
		default:
			break;
	}
}

/// XV
void MainMenuStateConduct::Update(float delta)
{
}

/// `
void MainMenuStateConduct::Render()
{
	DP(10, 10, 0xffffffff, _T("MainMenuStateConductB"));
}


//====================================================================================================
// Implement
//----------------------------------------------------------------------------------------------------

/// Ǘ擾
SP<MainMenuDataManager> MainMenuStateConduct::GetDataManager()
{
	return mPStateController->GetSequence()->GetDataManager();
}

/// ڂ肵ۂ̏s
void MainMenuStateConduct::DecidedMenuItem()
{
	switch ( GetDataManager()->GetFEConduct()->GetSelectedCommandTag() )
	{
		// TODO:ڂƂ̏

		// 
		case ItemCommandTag::eITEM_COMMAND_DESCRIPTION:
			GetDataManager()->GetFEConduct()->HandleInput(false);
			GetDataManager()->GetFEConduct()->SetVisible(false);
			mPStateController->ChangeState(MainMenuStateController::eSTATE_DESCRIPTION);

		// ̑
		default:
			break;
	};
}