#include "MainMenuFETop.h"

#include "Blast/Frontend/FEMenuEntryText.h"
#include "Blast/Graphic/DirectX9/FileTexture2DDX9.h"

using namespace Blast::Base;
using namespace Blast::Graphic;
using namespace Blast::Math;
using namespace Blast::Input;
using namespace Blast::Frontend;


//====================================================================================================
// Nameless
//----------------------------------------------------------------------------------------------------

namespace
{
	#define DEBUG_DISPLAY_KEY_X 10	///< L[͂fobO\ʒuX
	#define DEBUG_DISPLAY_KEY_Y 400	///< L[͂fobO\ʒuY
}


//====================================================================================================
// Operation
//----------------------------------------------------------------------------------------------------

/// RXgN^
MainMenuFETop::MainMenuFETop()
	: mPCamera(NULL)
	, mPWindow(NULL)
	, mIsHandleInput(true)
	, mIsEnable(true)
	, mIsVisible(true)
{
	// 2DJZbgAbv
	mPCamera.SetPointer(NEW Camera2D());
	
	// Gg[쐬
	const TCHAR* const kPEntryNames[eMENUENTRY_COUNT] =
	{
		_T(""),
		_T(""),	// TODO:ɉꍇɂ͋ςB
		_T("@\"),
	};
	const int kEntryNameCount = SIZE_OF_ARRAY(kPEntryNames);

	// EBhE쐬
	mPWindow.SetPointer(NEW SpriteDX9());

	mPWindow->SetCamera(mPCamera);

	ResourceManager* pRM = ResourceManager::GetInstance();
	SP<FileTexture2DDX9> pTex = pRM->Load<FileTexture2DDX9>(_T("./Res/Sprite/Window/TopWindow.png"));
	mPWindow->SetTexture(pTex);

	const Vector2 kSize(160, 192);
	mPWindow->SetSize(kSize);

	const Vector3 kLeftUpPosition(64, 128, 0);
	Vector3 pos = kLeftUpPosition;
	mPWindow->SetPosition(pos);

	mPWindow->SetOrigin(SpriteDX9::eORIGIN_UP_LEFT);

	
	/// j[쐬
	mPMenu.SetPointer(NEW FEMenu());
	mPMenu->SetPosition( Vector3(100, 175, 0) );

	for (int i = 0; i < kEntryNameCount; ++i)
	{
		SP<FEMenuEntryText> pFEText(NEW FEMenuEntryText());
		pFEText->SetCamera(mPCamera);
		pFEText->SetText(kPEntryNames[i]);

		mPMenu->AddItem(pFEText);
	}
}

/// fXgN^
MainMenuFETop::~MainMenuFETop() { }


/// 
void MainMenuFETop::Initialize()
{
}

/// 
void MainMenuFETop::HandleInput(float delta)
{
	if (!mIsHandleInput)
	{
		return;
	}

	// j[̓
	mPMenu->HandleInput(delta);
}

/// XV
void MainMenuFETop::Update(float delta)
{
	if (!mIsEnable)
	{
		return;
	}

	// J̍XV
	mPCamera->Update(delta);
	
	// EBhE̍XV
	if (mPWindow)
	{
		mPWindow->Update(delta);
	}

	// j[̍XV
	mPMenu->Update(delta);
}

/// `
void MainMenuFETop::Render()
{
	if (!mIsVisible)
	{
		return;
	}

	// EBhE̕`
	if (mPWindow)
	{
		mPWindow->Render();
	}

	// j[̕`
	mPMenu->Render();

	// ̎
	DP(10, 500, ColorCode::ToCode(ColorCode::eCOLOR_WHITE), _T("Fڂ̑I"));
}


//====================================================================================================
// Property
//----------------------------------------------------------------------------------------------------

/// ̓tO擾
bool MainMenuFETop::IsHandleInput() const
{
	return mIsHandleInput;
}

/// ̓tOݒ
void MainMenuFETop::SetHandleInput(bool value)
{
	mIsHandleInput = value;
}

/// XVtO擾
bool MainMenuFETop::IsEnbale() const
{
	return mIsEnable;
}

/// XVtOݒ
void MainMenuFETop::SetEnable(bool value)
{
	mIsEnable = value;
}

/// `tO擾
bool MainMenuFETop::IsVisible() const
{
	return mIsVisible;
}

/// `tOݒ
void MainMenuFETop::SetVisible(bool value)
{
	mIsVisible = value;
}

/// j[擾
SP<FEMenu> MainMenuFETop::GetMenu()
{
	return mPMenu;
}