#include "MainMenuFEItem.h"

#include "Blast/Frontend/FEMenuEntryText.h"
#include "Blast/Input/PadInputTag.h"
#include "ItemDatabase.h"
#include "Possession.h"

#include "ItemTag.h"

using namespace Blast::Base;
using namespace Blast::Graphic;
using namespace Blast::Math;
using namespace Blast::Input;
using namespace Blast::Frontend;


//====================================================================================================
// Operation
//----------------------------------------------------------------------------------------------------

/// RXgN^
MainMenuFEItem::MainMenuFEItem()
	: mPCamera(NULL)
	, mPWindow(NULL)
	, mIsHandleInput(true)
	, mIsEnable(true)
	, mIsVisible(true)
	, mESelectedItemTag(ItemTag::eITEM_INVALID)
{
	// 2DJZbgAbv
	mPCamera.SetPointer(NEW Camera2D());
	
	// EBhE쐬
	mPWindow.SetPointer(NEW SpriteDX9());
	mPWindow->SetCamera(mPCamera);

	ResourceManager* pRM = ResourceManager::GetInstance();
	SP<FileTexture2DDX9> pTex = pRM->Load<FileTexture2DDX9>(_T("./Res/Sprite/Window/ItemWindow.png"));
	mPWindow->SetTexture(pTex);
	mPWindow->FitTextureSize();

	const Vector3 kLeftUpPosition(64, 128, 0);
	Vector3 pos = kLeftUpPosition;
	mPWindow->SetPosition(pos);

	mPWindow->SetOrigin(SpriteDX9::eORIGIN_UP_LEFT);

	// j[쐬
	mPMenu.SetPointer(NEW FEMenu());
	mPMenu->SetPosition( Vector3(80, 176, 0) );

	Possession* pPossess = Possession::GetInstance();
	ItemDatabase* pIDB = ItemDatabase::GetInstance();
	for (int i = 0; i < pPossess->GetItemCount(); ++i)
	{
		// ̏擾
		const Possession::SItem* kPItem = pPossess->GetItemAt(i);
		const ItemDatabase::SCatalog* kPCatalog = pIDB->GetCatalogAt(kPItem->mID);
		
		// Gg\쐬
		SP<FEMenuEntryText> pFEText(NEW FEMenuEntryText());
		pFEText->SetCamera(mPCamera);
		pFEText->SetText(kPCatalog->mName);

		mPMenu->AddItem(pFEText);
	}
}

/// fXgN^
MainMenuFEItem::~MainMenuFEItem() { }


/// 
void MainMenuFEItem::Initialize()
{
}

/// 
void MainMenuFEItem::HandleInput(float delta)
{
	if (!mIsHandleInput)
	{
		return;
	}


	// TODO:ڋ@\

	
	// j[̓
	mPMenu->HandleInput(delta);
	
	// IĂ铹^Oێ
	if ( !Possession::GetInstance()->IsEmpty() )
	{
		const Possession::SItem* kPSelectedItem = Possession::GetInstance()->GetItemAt( mPMenu->GetSelectedIndex() );
		mESelectedItemTag = kPSelectedItem->mEItemTag;
	}
}

/// XV
void MainMenuFEItem::Update(float delta)
{
	if (!mIsEnable)
	{
		return;
	}

	// J̍XV
	mPCamera->Update(delta);

	// EBhE̍XV
	if (mPWindow)
	{
		mPWindow->Update(delta);
	}

	// j[̍XV
	mPMenu->Update(delta);
}

/// `
void MainMenuFEItem::Render()
{
	if (!mIsVisible)
	{
		return;
	}

	// EBhE̕`
	if (mPWindow)
	{
		mPWindow->Render();
	}

	// j[̕`
	mPMenu->Render();

	// ̎
	DP(10, 500, ColorCode::ToCode(ColorCode::eCOLOR_WHITE), _T("Fڂ̑I"));
}


//====================================================================================================
// Property
//----------------------------------------------------------------------------------------------------

/// ̓tO擾
bool MainMenuFEItem::IsHandleInput() const
{
	return mIsHandleInput;
}

/// ̓tOݒ
void MainMenuFEItem::SetHandleInput(bool value)
{
	mIsHandleInput = value;
}

/// XVtO擾
bool MainMenuFEItem::IsEnbale() const
{
	return mIsEnable;
}

/// XVtOݒ
void MainMenuFEItem::SetEnable(bool value)
{
	mIsEnable = value;
}

/// `tO擾
bool MainMenuFEItem::IsVisible() const
{
	return mIsVisible;
}

/// `tOݒ
void MainMenuFEItem::SetVisible(bool value)
{
	mIsVisible = value;
}

/// j[擾
SP<FEMenu> MainMenuFEItem::GetMenu()
{
	return mPMenu;
}

/// I𒆂̓^O擾
ItemTag::EItemTag MainMenuFEItem::GetSelectedItemTag() const
{
	return mESelectedItemTag;
}

/// I𒆂̓^Oݒ
void MainMenuFEItem::SetSelectedItemTag(ItemTag::EItemTag value)
{
	mESelectedItemTag = value;
}