#ifndef ITEMDATABASE_H
#define ITEMDATABASE_H

#include "Blast/Design/Singleton.h"
#include "ItemDataKind.h"
#include "ItemKindTag.h"


/// ACe̊Of[^SNX
class ItemDatabase :
	public Blast::Design::Singleton<ItemDatabase>
{
public:
	//====================================================================================================
	// Alias
	//----------------------------------------------------------------------------------------------------

	/// ޏ̔ž^
	typedef std::vector< SP<ItemDataKind> > KindList;

	
	//====================================================================================================
	// Struct
	//----------------------------------------------------------------------------------------------------

	/// J^O
	struct SCatalog
	{
		int mID;										///< ID
		ItemCatalogTag::EItemCatalogTag mECatalogTag;	///< ^O
		TCHAR mName[32];								///< O
		TCHAR mDisplayName[32];							///< \
		TCHAR mRuby[32];								///< r
		int mKindID;									///< ID
		int mEffectID;									///< ID
		int mOffence;									///< U
		int mDefence;									///< h
		TCHAR mModelFilePath[128];						///< ft@CpXBsvzB
		TCHAR mDescription[128];						///< 
	};

	/// ޏ
	struct SKind
	{
		int mID;								///< ID
		ItemKindTag::EItemKindTag mEKindTag;	///< ^O
		TCHAR mName[32];						///< O
		TCHAR mDropModelFilePath[128];			///< hbvft@CpXBsvzB
	};


	//====================================================================================================
	// Operation
	//----------------------------------------------------------------------------------------------------

	/// ރf[^ID擾
	const SP<ItemDataKind> GetKind(int) const;


	/// ꗗf[^Q擾
	const SP<SCatalog> GetCatalogs() const { return mCatalogs; }
	/// ꗗf[^擾
	const SCatalog* GetCatalogAt(int index) const { return &mCatalogs[index]; }
	/// ꗗf[^̐擾
	int GetCatalogCount() const { return mCatalogCount; }

	/// ރf[^Q擾
	const SP<SKind>& GetKinds2() const { return mSKinds2; }
	/// ރf[^擾
	const SKind& GetKinds2At(int index) const { return mSKinds2[index]; }

	
	//====================================================================================================
	// Implement
	//----------------------------------------------------------------------------------------------------

	/// RXgN^
	ItemDatabase();

	/// fXgN^
	virtual ~ItemDatabase();


	/// ꗗf[^ǂݍ
	void LoadCatalog(const TCHAR* const kPFullPath);

	/// ރf[^ǂݍ
	void LoadKind(const TCHAR* const kPFullPath);

private:
	/// ꗗf[^Q
	SP<SCatalog> mCatalogs;
	/// ꗗf[^̑
	int mCatalogCount;

	/// ރf[^Q
	KindList mKinds;

	/// ރf[^QB
	SP<SKind> mSKinds2;
};

#endif // ITEMDATABASE_H