#include "ItemDatabase.h"

#include "Blast/IO/CSVFile.h"
#include "Blast/IO/CSVTable.h"

using namespace Blast::IO;
using namespace Blast::Math;
using namespace Blast::String;


//====================================================================================================
// Nameless
//----------------------------------------------------------------------------------------------------

namespace 
{
	// J^OQBn[hR[fBO̎̂ݎgpB
	static const ItemDatabase::SCatalog nStKCatalogs[] =
	{
		{ 0, ItemCatalogTag::eITEM_TAG_WEAPON_SWORD, _T("O"), _T("\"), _T("r"), 0, 0, 99, 99, _T("ft@CpX"), _T("") },
	};
	// J^O̐
	static const int nStKCatalogCount = SIZE_OF_ARRAY(nStKCatalogs);

	// ޏQBn[hR[fBO̎̂ݎgpB
	static const ItemDatabase::SKind nStKKinds[] =
	{
		{ 0, ItemKindTag::eITEM_KIND_WEAPON, _T(""), _T(""), },
	};
	// ޏ̐
	static const int nStKKindCount = SIZE_OF_ARRAY(nStKKinds);
}


//====================================================================================================
// Operation
//----------------------------------------------------------------------------------------------------

/// ރf[^ID擾
const SP<ItemDataKind> ItemDatabase::GetKind(int id) const
{
	KindList::const_iterator kIt;
	for (kIt = mKinds.begin(); kIt != mKinds.end(); ++kIt)
	{
		if (id == (*kIt)->mID)
		{
			return (*kIt);
		}
	} 

	return SP<ItemDataKind>();
}


//====================================================================================================
// Implement
//----------------------------------------------------------------------------------------------------

/// RXgN^
ItemDatabase::ItemDatabase()
	: mCatalogCount(0)
{
	LoadCatalog(_T("./Res/DB/Item/ItemCatalog.bin"));
	LoadKind(_T("./Res/DB/Item/ItemKind.bin"));
}

/// fXgN^
ItemDatabase::~ItemDatabase()
{
}                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                


/// ꗗf[^ǂݍ
void ItemDatabase::LoadCatalog(const TCHAR* const kPFullPath)
{
	// CSVt@Cǂݍ
	CSVFile csv(kPFullPath);
	csv.Create();
	// e[u擾
	// R[hŃ[v
	const SP<CSVTable> pTable = csv.GetDataTable();
	const int kRowCount = csv.GetRowCount();

	// Ozׁ̈A
	//for (int i = 0; i < kRowCount; ++i)
	//{
	//	// R[h擾
	//	SP<CSVRecord> pRecord = pTable->GetRecord(i);
	//	
	//	// 쐬
	//	SP<ItemDataCatalog> pData(NEW ItemDataCatalog());
	//	pData->Load(pRecord);

	//	mCatalogs.push_back(pData);
	//}

	// z쐬ďB
#if 1	// 0ƃn[hR[fBOA1CSV擾
	mCatalogs.SetPointer(NEW SCatalog[kRowCount], true);
	ZeroMemory(mCatalogs.GetSource(), sizeof(SCatalog) * kRowCount);
	for (int i = 0; i < kRowCount; ++i)
	{
		// R[h擾
		const SP<CSVRecord> kPRecord = pTable->GetRecord(i);

		SCatalog& rData = mCatalogs[i];
		ZeroMemory(&rData, sizeof(rData));

		rData.mID = kPRecord->GetItem(_T("ID"))->GetValueRef();
		rData.mECatalogTag = ItemCatalogTag::ToTag(kPRecord->GetItem(_T("^O"))->GetValueRef().GetValueStrRef().c_str());
		_tcscpy_s(rData.mName, SIZE_OF_ARRAY(rData.mName), kPRecord->GetItem(_T("O"))->GetValueRef().GetValueStrRef().c_str());
		_tcscpy_s(rData.mDisplayName, SIZE_OF_ARRAY(rData.mDisplayName), kPRecord->GetItem(_T("\"))->GetValueRef().GetValueStrRef().c_str());
		_tcscpy_s(rData.mRuby, SIZE_OF_ARRAY(rData.mRuby), kPRecord->GetItem(_T("r"))->GetValueRef().GetValueStrRef().c_str());
		rData.mKindID = kPRecord->GetItem(_T("ID"))->GetValueRef();
		rData.mEffectID = kPRecord->GetItem(_T("ID"))->GetValueRef();
		rData.mOffence = kPRecord->GetItem(_T("U"))->GetValueRef();
		rData.mDefence = kPRecord->GetItem(_T("h"))->GetValueRef();
		_tcscpy_s(rData.mModelFilePath, SIZE_OF_ARRAY(rData.mModelFilePath), kPRecord->GetItem(_T("ft@CpX"))->GetValueRef().GetValueStrRef().c_str());
		_tcscpy_s(rData.mDescription, SIZE_OF_ARRAY(rData.mDescription), kPRecord->GetItem(_T(""))->GetValueRef().GetValueStrRef().c_str());
	}
	mCatalogCount = kRowCount;
#else
	const int kCatalogCount = SIZE_OF_ARRAY(nStKCatalogs);
	mCatalogs.SetPointer(NEW SCatalog[kCatalogCount], true);
	ZeroMemory(mCatalogs.GetSource(), sizeof(SCatalog) * kCatalogCount);
	for (int i = 0; i < kCatalogCount; ++i)
	{
		mCatalogs[i] = nStKCatalogs[i];
	}
	mCatalogCount = kCatalogCount;
#endif
}

/// ރf[^ǂݍ
void ItemDatabase::LoadKind(const TCHAR* const kPFullPath)
{
	// CSVt@Cǂݍ
	CSVFile csv(kPFullPath);
	csv.Create();

	// R[hŃ[v
	const SP<CSVTable> pTable = csv.GetDataTable();
	const int kRowCount = csv.GetRowCount();
	for (int i = 0; i < kRowCount; ++i)
	{
		// R[h擾
		SP<CSVRecord> pRecord = pTable->GetRecord(i);
		
		// 쐬
		SP<ItemDataKind> pData(NEW ItemDataKind());
		pData->Load(pRecord);

		mKinds.push_back(pData);
	}
	
	// z쐬ďB
#if 1	// 0ƃn[hR[fBOA1CSV擾
	mSKinds2.SetPointer(NEW SKind[kRowCount], true);
	ZeroMemory(mSKinds2.GetSource(), sizeof(SKind) * kRowCount);
	for (int i = 0; i < kRowCount; ++i)
	{
		// R[h擾
		const SP<CSVRecord> kPRecord = pTable->GetRecord(i);

		SKind& rData = mSKinds2[i];
		ZeroMemory(&rData, sizeof(rData));

		rData.mID = kPRecord->GetItem(_T("ID"))->GetValueRef();
		rData.mEKindTag = ItemKindTag::eITEM_CATALOG_TAG_INVALID;	//< 肭񂩂^Oɕϊ@\ƕ֗łB
		_tcscpy_s(rData.mName, SIZE_OF_ARRAY(rData.mName), kPRecord->GetItem(_T("O"))->GetValueRef().GetValueStrRef().c_str());
		_tcscpy_s(rData.mDropModelFilePath, SIZE_OF_ARRAY(rData.mDropModelFilePath), kPRecord->GetItem(_T("hbvft@CpX"))->GetValueRef().GetValueStrRef().c_str());
	}
#else
	mSKinds2.SetPointer(NEW SKind[nStKKindCount], true);
	ZeroMemory(mSKinds2.GetSource(), sizeof(SKind) * nStKKindCount);
	for (int i = 0; i < nStKKindCount; ++i)
	{
		mSKinds2[i] = nStKKinds[i];
	}
#endif
}