#include "GameWindow.h"

using namespace Blast::Math;
using namespace Blast::Graphic;


//====================================================================================================
// Operation
//----------------------------------------------------------------------------------------------------

/// RXgN^
GameWindow::GameWindow() :
mPosition(),
mSize(100)
{
	// 쐬
	Create();
}

/// fXgN^
GameWindow::~GameWindow()
{
}


/// XV
void GameWindow::Update(float delta)
{
	// EBhE̕iXV
	for (int i = 0; i < WindowPart::ePART_COUNT; ++i)
	{
		if (mPartPtrs[i])
		{
			mPartPtrs[i]->Update(delta);
		}
	}
}

/// `
void GameWindow::Render()
{
	// TODO:ƔėpۂƂɃXN̂ŁA͕`悵܂B
	return;


	//// EBhE̕i`
	//for (int i = 0; i < WindowPart::ePART_COUNT; ++i)
	//{
	//	if (mPartPtrs &&
	//		mPartPtrs[i])
	//	{
	//		mPartPtrs[i]->Render();
	//	}
	//} 
}


/// Jݒ
void GameWindow::SetCamera(const SP<ICamera> pCamera)
{
	for (int i = 0; i < WindowPart::ePART_COUNT; ++i)
	{
		mPartPtrs[i]->SetCamera(pCamera);
	}
}


/// ʒu擾
const Vector3& GameWindow::GetPosition() const
{
	return mPosition;
}

/// ʒuݒ
void GameWindow::SetPosition(const Vector3& kRPosition)
{
	mPosition = kRPosition;

	AlighnmentParts();
}


/// TCY擾
const Vector2& GameWindow::GetSize() const
{
	return mSize;
}

/// TCYݒ
void GameWindow::SetSize(const Vector2& kRSize)
{
	mSize = kRSize;

	AlighnmentParts();
}

/// TCY𑝌
void GameWindow::ShiftSize(const Vector2& kRValue)
{
	SetSize(mSize + kRValue);
}


//====================================================================================================
// PrivateOperation
//----------------------------------------------------------------------------------------------------

/// 쐬
void GameWindow::Create()
{
	// ǂݍރEBhE̕ĩt@C
	const TCHAR* const kPPartFileNames[WindowPart::ePART_COUNT] =
	{
		_T("./Res/Sprite/Window/WindowParts_0/WindowPart_1.png"),
		_T("./Res/Sprite/Window/WindowParts_0/WindowPart_2.png"),
		_T("./Res/Sprite/Window/WindowParts_0/WindowPart_3.png"),
		_T("./Res/Sprite/Window/WindowParts_0/WindowPart_4.png"),
		_T("./Res/Sprite/Window/WindowParts_0/WindowPart_5.png"),
		_T("./Res/Sprite/Window/WindowParts_0/WindowPart_6.png"),
		_T("./Res/Sprite/Window/WindowParts_0/WindowPart_7.png"),
		_T("./Res/Sprite/Window/WindowParts_0/WindowPart_8.png"),
		_T("./Res/Sprite/Window/WindowParts_0/WindowPart_9.png"),
	};

	// EBhE̍쐬
	for (int i = 0; i < WindowPart::ePART_COUNT; ++i)
	{
		SP<WindowPart> pPart(NEW WindowPart());
		mPartPtrs[i] = pPart;

		pPart->CreateWindowPart(kPPartFileNames[i], static_cast<WindowPart::EPart>(i));
	}

	// zu𐮗
	AlighnmentParts();
}

/// EBhE̕i̔zu𐮂
void GameWindow::AlighnmentParts()
{
	// EBhE̔̃TCY
	const Vector2 kHalfWindowSize = mSize * 0.5f;
	const Vector2& kHalfCornerPartSize = mPartPtrs[WindowPart::ePART_1]->GetSize();

	// SiŃ[v
	for (int i = 0; i < WindowPart::ePART_COUNT; ++i)
	{
		SP<WindowPart> pPart = mPartPtrs[i];

		const Vector2& kRTexSize = pPart->GetSize();
		const Vector2 kHalfTexSize = kRTexSize * 0.5f;
		Vector3 offset = mPosition;

		// XU
		if (i == WindowPart::ePART_1 ||
			i == WindowPart::ePART_4 ||
			i == WindowPart::ePART_7)
		{
			offset.mX -= kHalfWindowSize.mX - kHalfTexSize.mX;
		}

		if (i == WindowPart::ePART_3 ||
			i == WindowPart::ePART_6 ||
			i == WindowPart::ePART_9)
		{
			offset.mX += kHalfWindowSize.mX - kHalfTexSize.mX;
		}

		// YU
		if (i == WindowPart::ePART_1 ||
			i == WindowPart::ePART_2 ||
			i == WindowPart::ePART_3)
		{
			offset.mY -= kHalfWindowSize.mY - kHalfTexSize.mY;
		}

		if (i == WindowPart::ePART_7 ||
			i == WindowPart::ePART_8 ||
			i == WindowPart::ePART_9)
		{
			offset.mY += kHalfWindowSize.mY - kHalfTexSize.mY;
		}

		// ʒuU
		pPart->SetPosition(offset);


		// Zo
		Vector2 partSize = pPart->GetSize();
		if (i == WindowPart::ePART_2 ||
			i == WindowPart::ePART_5 ||
			i == WindowPart::ePART_8)
		{
			const float kWidth = mSize.mX - (kHalfCornerPartSize.mX * 2);
			partSize.mX = kWidth;
		}

		// cZo
		if (i == WindowPart::ePART_4 ||
			i == WindowPart::ePART_5 ||
			i == WindowPart::ePART_6)
		{
			const float kHeight = mSize.mY - (kHalfCornerPartSize.mY * 2);
			partSize.mY = kHeight;
		}
		
		// TCYύX
		pPart->SetSize(partSize);
	}
}