#include "FloorPlacementNPCData.h"

using namespace Blast::IO;


//====================================================================================================
// Operation
//----------------------------------------------------------------------------------------------------

/// RXgN^
FloorPlacementNPCData::FloorPlacementNPCData() :
mNPCID(-1),
mTilePosition(-1),
mDirection(-1)
{
}

/// fXgN^
FloorPlacementNPCData::~FloorPlacementNPCData()
{
}


/// ID擾
int FloorPlacementNPCData::GetID() const
{
	return mNPCID;
}


/// ǂݍ
void FloorPlacementNPCData::Load(const SP<CSVRecord> kPRecord)
{
	mNPCID = kPRecord->GetItem(_T("NPCID"))->GetValueRef().ToInteger();
	mTilePosition.mX = kPRecord->GetItem(_T("X"))->GetValueRef().ToInteger();
	mTilePosition.mY = kPRecord->GetItem(_T("Y"))->GetValueRef().ToInteger();
	mDirection = kPRecord->GetItem(_T(""))->GetValueRef().ToInteger();
}