#include "FloorPlacementEnemyData.h"

using namespace Blast::IO;


//====================================================================================================
// Operation
//----------------------------------------------------------------------------------------------------

/// RXgN^
FloorPlacementEnemyData::FloorPlacementEnemyData() :
mEnemyID(-1),
mTilePosition(-1),
mDirection(-1),
mIsSleep(false)
{
}

/// fXgN^
FloorPlacementEnemyData::~FloorPlacementEnemyData()
{
}


/// ID擾
int FloorPlacementEnemyData::GetID() const
{
	return mEnemyID;
}


/// ǂݍ
void FloorPlacementEnemyData::Load(const SP<CSVRecord> kPRecord)
{
	mEnemyID = kPRecord->GetItem(_T("EnemyID"))->GetValueRef().ToInteger();
	mTilePosition.mX = kPRecord->GetItem(_T("X"))->GetValueRef().ToInteger();
	mTilePosition.mY = kPRecord->GetItem(_T("Y"))->GetValueRef().ToInteger();
	mDirection = kPRecord->GetItem(_T(""))->GetValueRef().ToInteger();
	mIsSleep = kPRecord->GetItem(_T(""))->GetValueRef().ToBoolean();
}