#include "EnemyChip.h"

#include "Blast/Base/ResourceManager.h"
#include "MapDataManager.h"

using namespace Blast::Base;
using namespace Blast::Graphic;


//====================================================================================================
// Operation
//----------------------------------------------------------------------------------------------------

/// RXgN^
EnemyChip::EnemyChip()
	: mETag(EnemyChipTag::eCHIP_0)
{
}

/// fXgN^
EnemyChip::~EnemyChip()
{
}

/// 
void EnemyChip::Initialize(int id)
{
	mETag = static_cast<EnemyChipTag::EChipTag>(id);

	// f[^x[XQƂĒlێ
	const MapDataManager* pMD = MapDataManager::GetInstance();
	const MapDataManager::SEnemyChipData& kRData = pMD->GetEnemyChipData(mETag);


	// HACK:fǂݍށB̃NX쐬̂ŁAԂ̃{glbNɂȂB
	mPModel.SetPointer(NEW SkinModel());
	mPModel->LoadMesh(kRData.mPModelFilePath);

	// MEMO:̃NX`悷킯ȂAŃVF[_[𓖂ĂĂ
	ResourceManager* pRM = ResourceManager::GetInstance();
	SP<ShaderEffectDX9> pShader = pRM->Load<ShaderEffectDX9>(ShaderEffectDX9::ToFilePath(ShaderEffectDX9::eSHADEREFFECT_STANDARD_CONSTANT));
	mPModel->SetShaderEffect(pShader);

	// ̃eNjbNݒ
	#if _DEBUG
	pShader->SetTechnique(ShaderEffectDX9::ToTechniqueName(ShaderEffectDX9::eTECHNIQUE_CONSTANT_WIREFRAME));
	#else
	pShader->SetTechnique(ShaderEffectDX9::ToTechniqueName(ShaderEffectDX9::eTECHNIQUE_CONSTANT));
	#endif	// _DEBUG
}