#include "Direction.h"

using namespace Blast::Math;


//====================================================================================================
// Static
//----------------------------------------------------------------------------------------------------

/// ɂ񎟌Wl擾
void Direction::GetCoordinate2D(int* pOutX, int* pOutY, EDirection eDirection)
{
	// o͕ϐȂreturn
	ASSERT_PF(pOutX && pOutY, _T("|C^łB"));
	if (!pOutX || !pOutY)
	{
		return;
	}

	*pOutX = 0;
	*pOutY = 0;

	// ASSERT:ȕ̒lȂ玀
	ASSERT_PF(eDirection != eDIRECTION_INVALID, _T("ȕ̒lłBeDirection=%d"), eDirection);


	// ŕ
	const Point& kRPoint = stKCoordinate2Ds[eDirection];

	// o͕ϐɓ
	*pOutX = kRPoint.mX;
	*pOutY = kRPoint.mY;
}

/// ɂ񎟌Wl擾
Point Direction::GetCoordinate2D(EDirection eDirection)
{
	Point point;
	GetCoordinate2D(&point.mX, &point.mY, eDirection);

	return point;
}

/// ɂ񎟌Wl擾
void Direction::GetCoordinate2D(Point* pOutPoint, EDirection eDirection)
{
	ASSERT_PF(pOutPoint, _T("o͕ϐNULLłB"));
	if (pOutPoint)
	{
		GetCoordinate2D(&pOutPoint->mX, &pOutPoint->mY, eDirection);
	}
}


/// 񎟌Wl擾
void Direction::GetDirection(const Point& kRDelta, EDirection* pOut)
{
	GetDirection(kRDelta.mX, kRDelta.mY, pOut);
}

/// 񎟌Wl擾
void Direction::GetDirection(int x, int y, EDirection* pOut)
{
	// o͕ϐȂreturn
	ASSERT_PF(pOut, _T("|C^łB"));
	if (!pOut)
	{
		return;
	}

	// ASSERT:ȒlȂ玀
	ASSERT_PF(*pOut != eDIRECTION_INVALID, _T("ȒlłB"));


	// v̍W擾
	for (int i = 0; i < eDIRECTION_COUNT; ++i)
	{
		const Point& kRPoint = stKCoordinate2Ds[i];
		if (kRPoint.mX == x && kRPoint.mY == y)
		{
			*pOut = static_cast<EDirection>(i);

			return;
		}
	}

	// 擾łȂȂ疳ȒlԂ
	HALT(_T("擾ł܂łBx=%d, y=%d"), x, y);
	*pOut = eDIRECTION_INVALID;
}


/// eL[l̎ނ擾
void Direction::GetDirection(int tenkey, EDirection* pOut)
{
	// o͕ϐȂE
	ASSERT_PF(pOut, _T("o͕ϐłB"));
	if (!pOut)
	{
		return;
	}

	// eL[̒lŕ
	switch (tenkey)
	{
		case 1:		*pOut = eDIRECTION_1;			break;
		case 2:		*pOut = eDIRECTION_2;			break;
		case 3:		*pOut = eDIRECTION_3;			break;
		case 4:		*pOut = eDIRECTION_4;			break;
		case 5:		*pOut = eDIRECTION_5;			break;
		case 6:		*pOut = eDIRECTION_6;			break;
		case 7:		*pOut = eDIRECTION_7;			break;
		case 8:		*pOut = eDIRECTION_8;			break;
		case 9:		*pOut = eDIRECTION_9;			break;
		default:	*pOut = eDIRECTION_INVALID;		break;
	}
}


/// ɂ]l擾
float Direction::GetRotation(EDirection eDirection)
{
	const float kRad = stKRotations[eDirection]; 

	return kRad;
}


/// ΂߂ǂ擾
bool Direction::IsSlant(EDirection e)
{
	bool isSlant = false;

	switch (e)
	{
		case eDIRECTION_1:
		case eDIRECTION_3:
		case eDIRECTION_7:
		case eDIRECTION_9:
			isSlant = true;
			break;

		default:
			break;
	}

	return isSlant;
}

/// ΂߂ǂ擾
bool Direction::IsSlant(const Point& kRPoint)
{
	return !(kRPoint.mX == 0 && kRPoint.mY == 0);
}


//====================================================================================================
// Operation
//----------------------------------------------------------------------------------------------------

/// RXgN^
Direction::Direction() :
mEDirection(eDIRECTION_INITIAL)
{
}

/// fXgN^
Direction::~Direction()
{
}


/// 擾
Direction::EDirection Direction::GetDirection() const
{
	return mEDirection;
}

/// ݒ
void Direction::SetDirection(EDirection e)
{
	mEDirection = e;
}

/// v邩ǂ擾
bool Direction::IsDirection(EDirection e) const
{
	return (mEDirection == e);
}


/// ݂̌ɂ񎟌Wl擾
void Direction::GetCoordinate2D(int* pOutX, int* pOutY) const
{
	GetCoordinate2D(pOutX, pOutY, mEDirection);
}

/// ݂̌ɂ񎟌Wl擾
void Direction::GetCoordinate2D(Point* pOut) const
{
	// Lȃ|C^Ȃ珈
	ASSERT_PF(pOut, _T("|C^łB"));
	if (!pOut)
	{
		return;
	}

	// Ϗ
	GetCoordinate2D(&pOut->mX, &pOut->mY);
}


/// ݂̌ɂ]l擾
float Direction::GetRotation() const
{
	return GetRotation(mEDirection);
}

/// ݂̌΂߂ǂ擾
bool Direction::IsSlant() const
{
	return IsSlant(mEDirection);
}


/// =Zq
Direction& Direction::operator=(EDirection e)
{
	mEDirection = e;

	return *this;
}

/// ==Zq
bool Direction::operator==(EDirection e) const
{
	return IsDirection(e);
}


//====================================================================================================
// PrivateOperation
//----------------------------------------------------------------------------------------------------

/// ̓񎟌Wl
const Point Direction::stKCoordinate2Ds[eDIRECTION_COUNT] =
{
	Point(-1, 1),
	Point(0, 1),
	Point(1, 1),
	Point(-1, 0),
	Point(0, 0),
	Point(1, 0),
	Point(-1, -1),
	Point(0, -1),
	Point(1, -1),
};

/// ̉]l
const float Direction::stKRotations[eDIRECTION_COUNT] =
{
	MathHelper::ToRadian(45.0f),
	MathHelper::ToRadian(0.0f),
	MathHelper::ToRadian(-45.0f),
	MathHelper::ToRadian(90.0f),
	MathHelper::ToRadian(0.0f),
	MathHelper::ToRadian(-90.0f),
	MathHelper::ToRadian(135.0f),
	MathHelper::ToRadian(180.0f),
	MathHelper::ToRadian(-135.0f),
};