#include "CharacterDatabase.h"

#include "Blast/IO/CSVFile.h"
#include "Blast/IO/CSVTable.h"

using namespace Blast::IO;
using namespace Blast::Math;
using namespace Blast::String;


//====================================================================================================
// Operation
//----------------------------------------------------------------------------------------------------

/// RXgN^
CharacterDatabase::CharacterDatabase()
{
	LoadConsititution(_T("./Res/DB/Character/CharacterConsititution.bin"));
	LoadElement(_T("./Res/DB/Character/CharacterElement.bin"));
}

/// fXgN^
CharacterDatabase::~CharacterDatabase()
{
}


/// \f[^ǂݍ
void CharacterDatabase::LoadConsititution(const TCHAR* const kPFullPath)
{
	// CSVt@Cǂݍ
	CSVFile csv(kPFullPath);
	csv.Create();

	// e[u擾
	const SP<CSVTable> pTable = csv.GetDataTable();

	// R[hŃ[v
	const int kColumnCount = csv.GetColumnCount();
	const int kRowCount = csv.GetRowCount();
	for (int i = 0; i < kRowCount; ++i)
	{
		// R[h擾
		SP<CSVRecord> pRecord = pTable->GetRecord(i);
		
		// 쐬
		SP<SConsititution> pData(NEW SConsititution());
		pData->mID = pRecord->GetItem(_T("ID"))->GetValueRef().ToInteger();
		pData->mETag = i;
		_tcscpy_s(pData->mName, SIZE_OF_ARRAY(pData->mName), pRecord->GetItem(_T("O"))->GetValueRef().ToCharacter());
		_tcscpy_s(pData->mDisplayName, SIZE_OF_ARRAY(pData->mDisplayName), pRecord->GetItem(_T("\"))->GetValueRef().ToCharacter());
		pData->mLevel = pRecord->GetItem(_T("x"))->GetValueRef().ToInteger();
		pData->mHP = pRecord->GetItem(_T("HP"))->GetValueRef().ToInteger();
		pData->mOffence = pRecord->GetItem(_T("U"))->GetValueRef().ToInteger();
		pData->mDefence = pRecord->GetItem(_T("h"))->GetValueRef().ToInteger();
		pData->mExperience = pRecord->GetItem(_T("ol"))->GetValueRef().ToInteger();
		pData->mElementID = pRecord->GetItem(_T("ID"))->GetValueRef().ToInteger();
		pData->mLvUpID = pRecord->GetItem(_T("LvUpID"))->GetValueRef().ToInteger();
		pData->mLvDownID = pRecord->GetItem(_T("LvDownID"))->GetValueRef().ToInteger();
		_tcscpy_s(pData->mModelFilePath, SIZE_OF_ARRAY(pData->mModelFilePath), pRecord->GetItem(_T("ft@CpX"))->GetValueRef().ToCharacter());

		mSConsititutionDatas.push_back(pData);
	}
}

/// f[^ǂݍ
void CharacterDatabase::LoadElement(const TCHAR* const kPFullPath)
{
	// CSVt@Cǂݍ
	CSVFile csv(kPFullPath);
	csv.Create();

	// e[u擾
	const SP<CSVTable> pTable = csv.GetDataTable();

	// R[hŃ[v
	const int kColumnCount = csv.GetColumnCount();
	const int kRowCount = csv.GetRowCount();
	for (int i = 0; i < kRowCount; ++i)
	{
		// R[h擾
		SP<CSVRecord> pRecord = pTable->GetRecord(i);
		
		// 쐬
		SP<SElement> pData(NEW SElement());
		pData->mID = pRecord->GetItem(_T("ID"))->GetValueRef().ToInteger();
		pData->mETag = i;
		_tcscpy_s(pData->mName, SIZE_OF_ARRAY(pData->mName ), pRecord->GetItem(_T("O"))->GetValueRef().ToCharacter());
		
		mSElementDatas.push_back(pData);
	}
}


/// \f[^擾
const SP<CharacterDatabase::SConsititution> CharacterDatabase::GetConsititutionData(int id) const
{
	std::list< SP<SConsititution> >::const_iterator kIt = mSConsititutionDatas.begin();
	while (kIt != mSConsititutionDatas.end())
	{
		if ((*kIt)->mID == id)
		{
			return *kIt;
		}

		++kIt;
	}
	
	// HALT:擾łȂȂ痎Ƃ
	HALT(_T("f[^擾ł܂łB"));

	return SP<SConsititution>();
}

/// f[^擾
const SP<CharacterDatabase::SElement> CharacterDatabase::GetElementData(int id) const
{
	std::list< SP<SElement> >::const_iterator kIt = mSElementDatas.begin();
	while (kIt != mSElementDatas.end())
	{
		if ((*kIt)->mID == id)
		{
			return *kIt;
		}

		++kIt;
	}
	
	// HALT:擾łȂȂ痎Ƃ
	HALT(_T("f[^擾ł܂łB"));

	return SP<SElement>();
}


/// \f[^z擾
const std::list< SP<CharacterDatabase::SConsititution> >* CharacterDatabase::GetConsititutionDatas() const
{
	return &mSConsititutionDatas;
}

/// f[^z擾
const std::list< SP<CharacterDatabase::SElement> >* CharacterDatabase::GetElementDatas() const
{
	return &mSElementDatas;
}
