#include "Camera3DOperation.h"

using namespace Blast::Graphic;
using namespace Blast::Input;
using namespace Blast::Math;


//====================================================================================================
// Operation
//----------------------------------------------------------------------------------------------------

/// RXgN^
Camera3DOperation::Camera3DOperation()
{
}

/// fXgN^
Camera3DOperation::~Camera3DOperation()
{
}


/// 
void Camera3DOperation::HandleInput(float delta)
{
	// }EX擾
	IMouse* pMouse = InputManagerHelper::GetMouse();

	// 擾łȂȂȍ~͍̏sȂ
	if(!pMouse)
	{
		return;
	}


	// ͏󋵂擾
	bool isLeftDown = pMouse->IsDown(Buttons::eBUTTON_LEFT);
	bool isRightDown = pMouse->IsDown(Buttons::eBUTTON_RIGHT);
	bool isCenterDown = pMouse->IsDown(Buttons::eBUTTON_CENTER);
	bool isWheelUp = pMouse->IsWheelUp();
	bool isWheelDown = pMouse->IsWheelDown();


	// Ẽ{^ĂȂAړ͂ŃJʒȗOړs
	if (isLeftDown && isRightDown)
	{
		// Ÿړʂ̗p
		int dy = pMouse->GetDeltaPositionY();
		float dyRad = MathHelper::ToRadian(static_cast<float>(dy));
		
		const float kSpeed = 1.0f;
		float dyFloat = dy * kSpeed;

		Move(0, 0, -dyFloat, false);
	}
	// E{^ĂȂAړʕ]
	else if (isRightDown)
	{
		// XړY]ɁAYړX]Ɋ蓖Ă
		int dx = pMouse->GetDeltaPositionX();
		int dy = pMouse->GetDeltaPositionY();
		float dxRad = MathHelper::ToRadian(static_cast<float>(dx));
		float dyRad = MathHelper::ToRadian(static_cast<float>(dy));

		Vector3 delta(dyRad, dxRad, 0);
		const float kLength = delta.Length();
		delta.Normalize();
		delta *= kLength;

		// ]
		RevolveZXY(delta);
	}


	// {^ĂȂAړ͂Ńh[s
	if (isCenterDown)
	{
		// XړY]ɁAYړX]Ɋ蓖Ă
		int dx = pMouse->GetDeltaPositionX();
		int dy = pMouse->GetDeltaPositionY();

		Move(static_cast<float>(dx), static_cast<float>(dy), 0, true);
	}


	// zC[ɂ鎋p̕ϓpx
	const float kWheelZoomValue = MathHelper::ToRadian(1.0f);

	// zC[͂ŁAp̕ϓs
	if (isWheelUp)
	{
		Zoom(-kWheelZoomValue);
	}
	else if (isWheelDown)
	{
		Zoom(kWheelZoomValue);
	}

	// 
	const float kMinFOVY = MathHelper::ToRadian(0.1f);
	const float kMaxFOVY = MathHelper::ToRadian(179.0f);
	if (GetFieldOfViewY() < kMinFOVY)
	{
		SetFieldOfViewY(kMinFOVY);
	}
	else if (kMaxFOVY < GetFieldOfViewY())
	{
		SetFieldOfViewY(kMaxFOVY);
	}
}