#ifndef WIREFRAME_FX
#define WIREFRAME_FX

#include "EffectFunction.fx"


//====================================================================================================
// Struct
//----------------------------------------------------------------------------------------------------

/// C[t[`p
struct WIREFRAME_VS_OUTPUT
{
	float4 mPosition		: POSITION;
};


//====================================================================================================
// Shader
//----------------------------------------------------------------------------------------------------

/// C[t[o[ebNXVF[_
WIREFRAME_VS_OUTPUT WireframeVS(
	float4 position	: POSITION		// _ʒu
)
{
	// o̓f[^p
	WIREFRAME_VS_OUTPUT sOut = (WIREFRAME_VS_OUTPUT)0;


	// ʒuWݒ
	position = mul(position, gWorld);
	position = mul(position, gView);
	position = mul(position, gProjection);
	position = mul(position, gViewport);
	
	sOut.mPosition = position;


	return sOut;
}

///C[t[sNZVF[_
float4 WireframePS(WIREFRAME_VS_OUTPUT sIn) : COLOR
{
	// MEMO:At@l͕ʂɂǂł傤B
	// fBt[YF𔽓]
	float4 color = gDiffuse;
	color.r = 1 - gDiffuse.r;
	color.g = 1 - gDiffuse.g;
	color.b = 1 - gDiffuse.b;
	color.a = gDiffuse.a;


	return color;
}


#endif // WIREFRAME_FX
