#ifndef SPRITE3D_FX
#define SPRITE3D_FX

#include "stdafx.fx"


//====================================================================================================
// Struct
//----------------------------------------------------------------------------------------------------

/// AvP[V炭钸_obt@ւ̏
struct SAppData
{
	float3 mPosition	: POSITION;		///< ʒuW
	float4 mUV			: TEXCOORD0;	///< eNX`W
};

/// _obt@sNZVF[_֓nf[^
struct SVertexOutput
{
    float4 mPosition	: POSITION;		///< ʒuW
    float2 mUV			: TEXCOORD0;	///< eNX`W
};


//====================================================================================================
// VertexShader
//----------------------------------------------------------------------------------------------------

/// C
SVertexOutput MainVS(SAppData sIn)
{
	// o̓f[^p
	SVertexOutput sOut = (SVertexOutput)0;


	// ʒuWݒ
	float4 pos = float4(sIn.mPosition, 1.0f);
	pos = mul(pos, gWorld);
	pos = mul(pos, gView);
	pos = mul(pos, gProjection);
	pos = mul(pos, gViewport);

	sOut.mPosition = pos;


	// UVWݒ
	float4 uv4 = float4(sIn.mUV.xy, 1.0f, 1.0f);
	sOut.mUV = mul(uv4, gUVMatrix).xy;


	// o
	return sOut;
}


//====================================================================================================
// PixelShader
//----------------------------------------------------------------------------------------------------

/// C
float4 MainPS(SVertexOutput sIn) : COLOR
{
	// fBt[YJ[p
	float4 diffuseColor = tex2D(DiffuseSampler, sIn.mUV);

	// fBt[YeNX`TvO
	float3 result = diffuseColor.rgb * (0 + gAmbientColor);

    return float4(result, diffuseColor.a);
}

/// C[t[p
float4 WireframePS(SVertexOutput sIn) : COLOR
{
	// fBt[YJ[p
	float4 diffuseColor = tex2D(DiffuseSampler, sIn.mUV);

	// fBt[YeNX`TvO
	float3 result = diffuseColor.rgb * (0 + gAmbientColor);

	// یFɂȂȂ悤ɔ]
	result = float3(1, 1, 1) - result;

	return float4(result, 1);
}


//====================================================================================================
// Technique and Pass
//----------------------------------------------------------------------------------------------------

/// RX^g
technique Constant
{
	// \bh`pX
    pass Pass0
    {
        // _[Xe[gݒ
        AlphaTestEnable = True;
        AlphaBlendEnable = True;
        SrcBlend = SrcAlpha;
        DestBlend = InvSrcAlpha;
        Lighting = False;
        
#ifdef D3DX
	    CullMode = CCW;
#else
	    CullMode = CW;
#endif

        ZEnable = True;
        ZWriteEnable = True;
        
        // \bhw
        FillMode = Solid;
        
        
        // eNX`Xe[WXe[gݒ
        TEXTURETRANSFORMFLAGS[0] = COUNT2;
        ColorOp[0] = MODULATE;
        ColorArg1[0] = TEXTURE;
        ColorArg2[0] = DIFFUSE;
        AlphaOp[0] = MODULATE;
        AlphaArg1[0] = TEXTURE;
        AlphaArg2[0] = DIFFUSE;
        
        
        // o[ebNXVF[_
        VertexShader = compile vs_2_0 MainVS();
        
        // sNZVF[_
        PixelShader  = compile ps_2_0 MainPS();
    }
}

/// C[t[
technique WireFrame
{
	// C[t[`pX
    pass Pass0
    {
        ZEnable = True;
        ZWriteEnable = True;
        FillMode = Wireframe;
	    CullMode = None;
        
        
        // o[ebNXVF[_
        VertexShader = compile vs_2_0 MainVS();
        
        // sNZVF[_
        PixelShader  = compile ps_2_0 WireframePS();
    }
}

/// RX^gɉăC[t[
technique ConstantWireFrame
{
	// \bh`pX
    pass Pass0
    {
        // _[Xe[gݒ
        AlphaTestEnable = True;
        AlphaBlendEnable = True;
        SrcBlend = SrcAlpha;
        DestBlend = InvSrcAlpha;
        Lighting = False;
        
#ifdef D3DX
	    CullMode = CCW;
#else
	    CullMode = CW;
#endif

        ZEnable = True;
        ZWriteEnable = True;
        FillMode = Solid;
        
        
        // eNX`Xe[WXe[gݒ
        TEXTURETRANSFORMFLAGS[0] = COUNT2;
        ColorOp[0] = MODULATE;
        ColorArg1[0] = TEXTURE;
        ColorArg2[0] = DIFFUSE;
        AlphaOp[0] = MODULATE;
        AlphaArg1[0] = TEXTURE;
        AlphaArg2[0] = DIFFUSE;
        
        
        // o[ebNXVF[_
        VertexShader = compile vs_2_0 MainVS();
        
        // sNZVF[_
        PixelShader  = compile ps_2_0 MainPS();
    }

	// C[t[`pX
    pass Pass1
    {
        ZEnable = True;
        ZWriteEnable = True;
        FillMode = Wireframe;
	    CullMode = None;
        
        
        // o[ebNXVF[_
        VertexShader = compile vs_2_0 MainVS();
        
        // sNZVF[_
        PixelShader  = compile ps_2_0 WireframePS();
    }
}

#endif // SPRITE3D_FX
