#ifndef SKIN_WIREFRAME_FX
#define SKIN_WIREFRAME_FX

#include "EffectFunction.fx"


//====================================================================================================
// Struct
//----------------------------------------------------------------------------------------------------

/// o[ebNXVF[_[ւ̓͏
struct SSkinWireframeVSIn
{
	/// _W
	float4 mPosition		: POSITION;

	/// {[CfbNX
	uint4  mBoneIndices		: BLENDINDICES;

	/// {[EFCg
	float4 mBoneWeights		: BLENDWEIGHT;
};

/// sNZVF[_[ւ̓͏
struct SSkinWireframePSIn
{
	/// _W
	float4 mPosition		: POSITION;
};


//====================================================================================================
// Shader
//----------------------------------------------------------------------------------------------------

/// C[t[o[ebNXVF[_
SSkinWireframePSIn SkinWireframeVS(SSkinWireframeVSIn sIn)
{
	// o̓f[^p
	SSkinWireframePSIn sOut = (SSkinWireframePSIn)0;


	// XLjO
	SSkinning sSkinning = Skinning(sIn.mPosition, float3(0, 0, 0), sIn.mBoneIndices, sIn.mBoneWeights);

	// ʒuWݒ
	sOut.mPosition = mul(sSkinning.mPosition, gWVP);


	return sOut;
}

///C[t[sNZVF[_
float4 SkinWireframePS(SSkinWireframePSIn sIn) : COLOR
{
	// MEMO:At@l͕ʂɂǂł傤B
	// fBt[YF𔽓]
	float4 color = gDiffuse;
	color.r = 1 - gDiffuse.r;
	color.g = 1 - gDiffuse.g;
	color.b = 1 - gDiffuse.b;
	color.a = gDiffuse.a;


	return color;
}


#endif // SKIN_WIREFRAME_FX
