#ifndef SKIN_CONSTANT_FX
#define SKIN_CONSTANT_FX

#include "EffectFunction.fx"


//====================================================================================================
// Struct
//----------------------------------------------------------------------------------------------------

/// o[ebNXVF[_[̓͏
struct SSkinConstantVSIn
{
	/// _ʒu
	float4 mPosition		: POSITION;

	/// UV
	float2 mUV				: TEXCOORD0;

	/// {[CfbNX
	uint4  mBoneIndices		: BLENDINDICES;

	/// {[EFCg
	float4 mBoneWeights		: BLENDWEIGHT;
};

/// sNZVF[_[̓͏
struct SSkinConstantPSIn
{
	/// _ʒu
	float4 mPosition		: POSITION;

	/// UV
	float2 mUV				: TEXCOORD0;

	/// F
	float4 mColor			: TEXCOORD1;

	// MEMO:PIXo͗p
	/// {[CfbNX
	//uint4  mBoneIndices		: TEXCOORD2;

	// MEMO:PIXo͗p
	/// {[EFCg
	//float4 mBoneWeights		: TEXCOORD3;
};


//====================================================================================================
// Shader
//----------------------------------------------------------------------------------------------------

/// XLo[ebNXVF[_
SSkinConstantPSIn SkinConstantVS(SSkinConstantVSIn sIn)
{
	// sNZVF[_[ւ̏o̓f[^p
	SSkinConstantPSIn sOut = (SSkinConstantPSIn)0;


	// XLjO
	SSkinning sSkinning = Skinning(sIn.mPosition, float3(0, 0, 0), sIn.mBoneIndices, sIn.mBoneWeights);


	// ʒuWݒ
	sOut.mPosition = mul(sSkinning.mPosition, gWVP);

	// UVWݒ
	float4 uv4 = float4(sIn.mUV.x, sIn.mUV.y, 1.0f, 1.0f);
	sOut.mUV = mul(uv4, gUVMatrix).xy;


	// Z
	sOut.mColor.rgb += CalcAmbient();


	// MEMO:ʂ̕ϐpӂǂł傤B
	// At@sł1ɐݒ
	sOut.mColor.a = 1;


	// MEMO:PIXo͗p
	//sOut.mBoneIndices = sIn.mBoneIndices;
	//sOut.mBoneWeights = sIn.mBoneWeights;


	// o
	return sOut;
}

/// XLsNZVF[_
float4 SkinConstantPS(SSkinConstantPSIn sIn) : COLOR
{
	// sNZJ[p
	float4 pixelColor = sIn.mColor;

	// fBt[YeNX`TvO
	pixelColor *= DiffuseTextureSampling(sIn.mUV);


    return pixelColor;
}


#endif // SKIN_CONSTANT_FX
