#include "WindowPart.h"

#include "Blast/Graphic/DirectX9/FileTexture2DDX9.h"

using namespace Blast::Graphic;
using namespace Blast::Math;


//====================================================================================================
// Operation
//----------------------------------------------------------------------------------------------------

/// RXgN^
WindowPart::WindowPart() :
mEPart(ePART_INVALID)
{
}

/// fXgN^
WindowPart::~WindowPart()
{
}


/// XV
void WindowPart::Update(float delta)
{
	// XvCgXV
	if (mPSprite)
	{
		mPSprite->Update(delta);
	}
}

/// `
void WindowPart::Render()
{
	// XvCg`
	if (mPSprite)
	{
		mPSprite->Render();
	}
}


/// i쐬
bool WindowPart::CreateWindowPart(const TCHAR* const kPFullPath, EPart ePart)
{
	// XvCg쐬
	mPSprite.SetPointer(NEW SpriteDX9());
	mPSprite->Initialize();

	// eNX`ݒ
	SP<FileTexture2DDX9> pTex(NEW FileTexture2DDX9());
	pTex->Load(kPFullPath);

	mPSprite->SetTexture(pTex);

	// _ݒ
	mPSprite->SetOrigin(SpriteDX9::eORIGIN_CENTER);
	

	// i̎ނێ
	mEPart = ePart;


	return true;
}


//====================================================================================================
// Transfar
//----------------------------------------------------------------------------------------------------

/// Jݒ
void WindowPart::SetCamera(const SP<ICamera> pCamera)
{
	// XvCgȂ玀
	ASSERT_PF(mPSprite, _T("mPSpriteNullłB"));
	if (!mPSprite)
	{
		return;
	}
	
	mPSprite->SetCamera(pCamera);
}


/// ʒu擾
const Vector3& WindowPart::GetPosiion() const
{
	// XvCgȂ玀
	ASSERT_PF(mPSprite, _T("mPSpriteNullłB"));
	if (!mPSprite)
	{
		return Vector3::Zero();
	}
	
	return mPSprite->GetPosition();
}

/// ʒuݒ
void WindowPart::SetPosition(const Vector3& kRPosition)
{
	// XvCgȂ玀
	ASSERT_PF(mPSprite, _T("mPSpriteNullłB"));
	if (!mPSprite)
	{
		return;
	}
	
	mPSprite->SetPosition(kRPosition);
}


/// TCY擾
const Vector2& WindowPart::GetSize() const
{
	// XvCgȂ玀
	ASSERT_PF(mPSprite, _T("mPSpriteNullłB"));
	if (!mPSprite)
	{
		return Vector2::Zero();
	}
	
	return mPSprite->GetSize();
}

/// TCYݒ
void WindowPart::SetSize(const Vector2& kRSize)
{
	// XvCgȂ玀
	ASSERT_PF(mPSprite, _T("mPSpriteNullłB"));
	if (!mPSprite)
	{
		return;
	}
	
	mPSprite->SetSize(kRSize);
}
