#include "ViewUnit.h"

#include "./Sequence/MainGameSequence.h"
#include "./MainGameViewManager.h"
#include "./MainGameDataManager.h"

using namespace Blast::Base;
using namespace Blast::Graphic;
using namespace Blast::Math;


//====================================================================================================
// Operation
//----------------------------------------------------------------------------------------------------

/// RXgN^
ViewUnit::ViewUnit(MainGameViewManager* pViewManager)
	: mPViewManager(pViewManager)
	, mIsVisible(true)
{
	// vC[̃f쐬
	mPPlayerModel.SetPointer(NEW SkinModel());

	// G̃f쐬
	mPEnemyModel.SetPointer(NEW SkinModel());
	mPEnemyModel->LoadMesh(_T("./Res/Model/Characters/99_Celsius/Celsius_Small.FBX"));

	// VF[_[ǂݍ
	ResourceManager* pRM = ResourceManager::GetInstance();
	mPShader = pRM->Load<ShaderEffectDX9>(ShaderEffectDX9::ToFilePath(ShaderEffectDX9::eSHADEREFFECT_CHARACTER));
}

/// fXgN^
ViewUnit::~ViewUnit()
{
}

/// XV
void ViewUnit::Update(float delta)
{
	if (!mIsEnable)
	{
		return;
	}

	// vC[fXV
	if (mPPlayerModel)
	{
		mPPlayerModel->Update(delta);
	}

	// G̃fXV
	if (mPEnemyModel)
	{
		mPEnemyModel->Update(delta);
	}
}

/// `
void ViewUnit::Render()
{
	if (!mIsVisible)
	{
		return;
	}

	// UNDONE:vC[f`
	UnitManager::UnitList playerUnits;
	GetDataMgr()->GetUnitManager()->GetRoleUnits(&playerUnits, Unit::eROLE_PLAYER);
	if (!playerUnits.empty())
	{
		// vC[̖1݂̂̂Ȃ̂Ń`FbNĂ
		ASSERT_PF(playerUnits.size() == 1, _T("vC[̖S1̂ł͂܂łB"));

		UnitManager::UnitList::const_iterator kIt;
		for (kIt = playerUnits.begin(); kIt != playerUnits.end(); ++kIt)
		{
			if (mPPlayerModel && mPPlayerModel->IsLoaded())
			{
				// ʒu
				mPPlayerModel->SetPosition( (*kIt)->GetWorldPosition() );

				// ]
				const float kRot = Direction::GetRotation( (*kIt)->GetDirection() );
				mPPlayerModel->SetRotation(Vector3::UnitY() * kRot);

				mPPlayerModel->SetCamera( GetDataMgr()->GetCamera() );
				mPPlayerModel->SetShaderEffect(mPShader);
				mPPlayerModel->Render();
			}
		}
	}

	// UNDONE:G̃f`
	UnitManager::UnitList enemies;
	GetDataMgr()->GetUnitManager()->GetRoleUnits(&enemies, Unit::eROLE_ENEMY);
	if (!enemies.empty())
	{
		UnitManager::UnitList::const_iterator kIt;
		for (kIt = enemies.begin(); kIt != enemies.end(); ++kIt)
		{
			if (mPEnemyModel && mPEnemyModel->IsLoaded())
			{
				// ʒu
				const SP<TerrainGrid::STile> kPTile = GetDataMgr()->GetTerrainGrid()->GetTileAt( (*kIt)->GetGridPosition() );
				mPEnemyModel->SetPosition( kPTile->mWorldPosition );

				// ]
				const float kRot = Direction::GetRotation( (*kIt)->GetDirection() );
				mPEnemyModel->SetRotation(Vector3::UnitY() * kRot);

				mPEnemyModel->SetCamera( GetDataMgr()->GetCamera() );
				mPEnemyModel->SetShaderEffect(mPShader);
				mPEnemyModel->Render();
			}
		}
	}
}

/// vC[ݒ
void ViewUnit::SetPlayer(int id)
{
	// UNDONE:idK؂ȃfǂݍ

	// vC[LN^[쐬
	// ̓t@NgNXg킸̂܂܍쐬ĂB͂łB
	mPPlayerModel->LoadMesh(_T("./Res/Model/Characters/102_IzayoiSakuya/Mesh.FBX"));
}


//====================================================================================================
// Property
//----------------------------------------------------------------------------------------------------

/// XVtO擾
bool ViewUnit::IsEnbale() const
{
	return mIsEnable;
}

/// XVtOݒ
void ViewUnit::SetEnbale(bool value)
{
	mIsEnable = value;
}

/// `tO擾
bool ViewUnit::IsVisible() const
{
	return mIsVisible;
}

/// `tOݒ
void ViewUnit::SetVisible(bool value)
{
	mIsVisible = value;
}


//====================================================================================================
// Implement
//----------------------------------------------------------------------------------------------------

/// Ǘ擾
SP<MainGameDataManager> ViewUnit::GetDataMgr()
{
	return mPViewManager->GetSequence()->GetDataManager();
}