#include "Unit.h"

#include "CharacterTag.h"

using namespace Blast::Math;


//====================================================================================================
// Static
//----------------------------------------------------------------------------------------------------

/// ړʁBϓȂ萔ł͂ȂϐɂKvB
const float Unit::stKMoveValue = 100.0f;


//====================================================================================================
// Operation
//----------------------------------------------------------------------------------------------------

/// RXgN^
Unit::Unit()
	: mECharacterTag(CharacterTag::eCHARACTER_RYUTO)
	, mERole(eROLE_PLAYER)
	, mGridPosition()
	, mWorldPosition()
	, mEDirection(Direction::eDIRECTION_2)
	, mTargetMovePosition()
	, mLeftMoveTime(0)
	, mFrameMoveValue()
{
}

/// fXgN^
Unit::~Unit()
{
}

/// XV
void Unit::Update(float delta)
{
	// ړɕKvȎc莞ԂȂړs
	if (0 < mLeftMoveTime)
	{
		mWorldPosition += mFrameMoveValue;
		mLeftMoveTime -= delta;
		if (mLeftMoveTime < 0)
		{
			mLeftMoveTime = 0;
			mWorldPosition = mTargetMovePosition;
		}
	}
}

/// ړ
void Unit::Move(const Point& kRDeltaValue)
{
	Vector3 moveValue;
	moveValue.mX = kRDeltaValue.mX * stKMoveValue;
	moveValue.mZ = kRDeltaValue.mY * stKMoveValue * -1;	//< tȂ̂ŕɂB

	mStartMovePosition = mWorldPosition;
	mTargetMovePosition = mStartMovePosition + moveValue;
	mLeftMoveTime = 0.1f;
	mFrameMoveValue = moveValue * (1 / 60.0f) / mLeftMoveTime;	//< FPS̒lŎZoĂ邪Ał
}

/// ړǂ擾
bool Unit::IsMoving() const
{
	return (0 < mLeftMoveTime);
}


//====================================================================================================
// Property
//----------------------------------------------------------------------------------------------------

/// L^O擾
CharacterTag::ECharacterTag Unit::GetCharacterTag() const { return mECharacterTag; }
/// L^Oݒ
void Unit::SetCharacterTag(CharacterTag::ECharacterTag value) { mECharacterTag = value; }

/// ^O擾
Unit::ERole Unit::GetRoleTag() const { return mERole; }
/// ^Oݒ
void Unit::SetRoleTag(ERole value) { mERole = value; }

/// ObhW擾
const Point& Unit::GetGridPosition() const { return mGridPosition; }
/// ObhWݒ
void Unit::SetGridPosition(const Point& value) { mGridPosition = value; }

/// [hW擾
const Vector3& Unit::GetWorldPosition() const { return mWorldPosition; }
/// [hWݒ
void Unit::SetWorldPosition(const Vector3& value) { mWorldPosition = value; }

/// 擾
Direction::EDirection Unit::GetDirection() const { return mEDirection; }
/// ݒ
void Unit::SetDirection(Direction::EDirection value) { mEDirection = value; }