#include "TitleStateController.h"

#include "./Sequence/TitleSequence.h"
#include "TitleStateTop.h"


//====================================================================================================
// Operation
//----------------------------------------------------------------------------------------------------

/// RXgN^
TitleStateController::TitleStateController(TitleSequence* pSeq)
	: mPSequence(pSeq)
{
	// ̏Ԃݒ
	SP<TitleStateTop> pState(NEW TitleStateTop(this));
	mPCurrentState = pState;
}

/// fXgN^
TitleStateController::~TitleStateController()
{
}

/// 
void TitleStateController::HandleInput(float delta)
{
	// ݂̏Ԃ̓
	if (mPCurrentState)
	{
		mPCurrentState->HandleInput(delta);
	}
}

/// XV
void TitleStateController::Update(float delta)
{
	// ݂̏Ԃ̍XV
	if (mPCurrentState)
	{
		mPCurrentState->Update(delta);
	}
}

/// `
void TitleStateController::Render()
{
	// ʏԂ̕`
	if (mPCurrentState)
	{
		mPCurrentState->Render();
	}
}

/// V[PX擾
TitleSequence* TitleStateController::GetSequence()
{
	return mPSequence;
}

/// Ǘ擾
SP<TitleDataManager> TitleStateController::GetDataManager()
{
	return mPSequence->GetDataManager();
}


/// ԂύX
void TitleStateController::ChangeState(SP<ITitleState> pState)
{
	mPCurrentState = pState;
}

/// ԂύX
void TitleStateController::ChangeState(EState eState)
{
	SP<ITitleState> pState;
	switch (eState)
	{
		case eSTATE_CONSTRUCT:
			pState.SetPointer(NEW TitleStateTop(this));
			break;

		case eSTATE_NORMAL:
			// TODO:Xe[g̒ǉ
			//pState.SetPointer(NEW MainGameStateNormal(this));
			break;
	}

	ASSERT_PF(pState, _T("NULLState肵悤Ƃ܂B"));
	mPPreState = mPCurrentState;
	mPCurrentState = pState;
}
