#ifndef TILE_H
#define TILE_H

#include "Blast/Base/RenderableGameComponent.h"
#include "Blast/Graphic/DirectX9/StaticModelDX9.h"
#include "Blast/Graphic/DirectX9/CrosshairDX9.h"
#include "Blast/Graphic/ICamera.h"


/// 1}X̏SNX
class Tile
	: public Blast::Base::RenderableGameComponent
{
public:
	//====================================================================================================
	// Operation
	//----------------------------------------------------------------------------------------------------

	/// RXgN^
	Tile();

	/// fXgN^
	virtual ~Tile();


	/// 
	void Initialize(
		int chipIndex,
		int chipInstanceIndex,
		const Blast::Math::Point& kRTilePosition,
		const Blast::Math::Vector3& kRWorldPosition);

	/// XV
	virtual void Update(float);

	/// `
	virtual void Render();


	/// QƐ̃`bvCfbNX擾
	int GetChipIndex() const { return mChipIndex; }

	/// Ή`bvCX^X̃CfbNX擾
	int GetChipInstanceIndex() const { return mChipInstanceIndex; }

	/// tÄʒu擾
	const Blast::Math::Point& GetTilePosition() const { return mTilePosition; }

	/// [hẄʒu
	const Blast::Math::Vector3& GetWorldPosition() const { return mWorldPosition; }


	/// Jݒ
	void SetCamera(const SP<Blast::Graphic::ICamera> pCamera) { mPCamera = pCamera; }

private:
	/// QƐ̃`bvCfbNX
	int mChipIndex;

	/// Ή`bvCX^X̃CfbNX
	int mChipInstanceIndex;

	/// tÄʒu
	Blast::Math::Point mTilePosition;

	/// [hẄʒu
	Blast::Math::Vector3 mWorldPosition;


	/// J
	SP<Blast::Graphic::ICamera> mPCamera;

	/// NXwA
	SP<Blast::Graphic::CrosshairDX9> mPCrosshair;
};

#endif // TILE_H