#include "SkinModel.h"

#include "Blast/Base/ResourceManager.h"
#include "Blast/Graphic/DirectX9/FileTexture2DDX9.h"
#include "Blast/Storage/Directory.h"
#include "Blast/String/StringHelper.h"

using namespace fbxsdk_2012_2;
using namespace Blast::Base;
using namespace Blast::Graphic;
using namespace Blast::Math;
using namespace Blast::Storage;
using namespace Blast::String;


//====================================================================================================
// Nameless
//----------------------------------------------------------------------------------------------------

namespace
{
	/// }eAp̃eNX`ǂݍ
	bool LoadMaterialTexture(const TCHAR* const kPFilePath, SP<Texture2DDX9>* ppOutTexture)
	{
		SP<FileTexture2DDX9> pTex(NEW FileTexture2DDX9());
		bool isSuccess = pTex->Load(kPFilePath);
		if (isSuccess)
		{
			*ppOutTexture = pTex;
		}
		else
		{
			return false;
		}

		return true;
	}
	
	/// Get the matrix of the given pose
	/// |[Yϊs擾
	KFbxXMatrix GetPoseMatrix(KFbxPose* pPose, int pNodeIndex)
	{
		KFbxXMatrix oseMatrix;
		KFbxMatrix lMatrix = pPose->GetMatrix(pNodeIndex);

		memcpy((double*)oseMatrix, (double*)lMatrix, sizeof(lMatrix.mData));

		return oseMatrix;
	}

	/// m[h̃O[oȈʒuA܂胍[Jł͂Ȃʒu擾B
	KFbxXMatrix GetGlobalPosition(
		KFbxNode* pNode,
		const KTime& rTime,
		KFbxPose* pPose,
		KFbxXMatrix* pParentGlobalPosition
		)
	{
		KFbxXMatrix globalPosition;
		bool isPositionFound = false;

		if (pPose)
		{
			const int kNodeIndex = pPose->Find(pNode);

			if (-1 < kNodeIndex)
			{
				// The bind pose is always a global matrix.
				// If we have a rest pose, we need to check if it is
				// stored in global or local space.
				if (pPose->IsBindPose() || !pPose->IsLocalMatrix(kNodeIndex))
				{
					globalPosition = GetPoseMatrix(pPose, kNodeIndex);
				}
				else
				{
					// We have a local matrix, we need to convert it to
					// a global space matrix.
					KFbxXMatrix lParentGlobalPosition;

					if (pParentGlobalPosition)
					{
						lParentGlobalPosition = *pParentGlobalPosition;
					}
					else
					{
						if (pNode->GetParent())
						{
							lParentGlobalPosition = GetGlobalPosition(pNode->GetParent(), rTime, pPose, NULL);
						}
					}

					KFbxXMatrix lLocalPosition = GetPoseMatrix(pPose, kNodeIndex);
					globalPosition = lParentGlobalPosition * lLocalPosition;
				}

				isPositionFound = true;
			}
		}

		if (!isPositionFound)
		{
			globalPosition = pNode->EvaluateGlobalTransform(rTime);
		
#if CONFIRM || 1
			static int stCount = 0;
			if (stCount < 10)
			{
				++stCount;

				KFbxVector4 fbxS = globalPosition.GetS();
				KFbxVector4 fbxR = globalPosition.GetR();
				/* WA\ɂȂRgO */
				//for (int i = 0; i < 4; ++i)
				//{
				//	fbxR[i] = MathHelper::ToRadian(fbxR[i]);
				//}
				KFbxVector4 fbxT = globalPosition.GetT();
				#if 0	//< _vp
				PFL(_T("m[hu%svEvaluateGlobalTransform()̓(S%d/10):\n\tS(%lf, %lf, %lf)\n\tR(%lf, %lf, %lf)\n\tT(%lf, %lf, %lf)"),
					StringHelper::ToWideChar(pNode->GetName()).c_str(),
					stCount,
					fbxS[0], fbxS[1], fbxS[2],
					fbxR[0], fbxR[1], fbxR[2],
					fbxT[0], fbxT[1], fbxT[2]
					);
				#endif
			}
#endif // CONFIRM
		}

		return globalPosition;
	}

	/// WIgɕۑꂽό`擾
	KFbxXMatrix GetGeometry(KFbxNode* kPNode)
	{
		return KFbxXMatrix();

		// MEMO:ԂFBX̗xNgɍ킹č珇ɑǂł傤H
		// KFbxMatrix̃RXgN^TRS̏Ŏ󂯎낤ƂĂ̂łɍ킹܂B
		KFbxVector4 geoT = kPNode->GetGeometricTranslation(KFbxNode::eSOURCE_SET);
		KFbxVector4 geoR = kPNode->GetGeometricRotation(KFbxNode::eSOURCE_SET);
		KFbxVector4 geoS = kPNode->GetGeometricScaling(KFbxNode::eSOURCE_SET);

		return KFbxXMatrix(geoT, geoR, geoS);
	}
	
    /// SẴ|[YLbV
    void FillPoseArray(KFbxScene* pScene, KArrayTemplate<KFbxPose*>& pPoseArray)
    {
        const int kPoseCount = pScene->GetPoseCount();
		PFL(_T("Found %s's KFbxPose Count:%d"), StringHelper::ToWideChar(pScene->GetName()).c_str(), kPoseCount);

        for (int i = 0; i < kPoseCount; ++i)
        {
			KFbxPose* pPose = pScene->GetPose(i);
            pPoseArray.Add(pScene->GetPose(i));

#if _DEBUG	// |[Y_v܂B
			TCHAR poseName[StringHelper::mStKDefaultBufferSize];
			ZeroMemory(poseName, sizeof(poseName));
			StringHelper::ToWideChar(NULL, poseName, StringHelper::mStKDefaultBufferSize, pPose->GetName());
			PFL(_T("\tKFbxPose[%d]=%s"), i, poseName);
#endif // _DEBUG
        }
    }
	
	//Compute the transform matrix that the cluster will transform the vertex.
	// NX^̏ɉĒ_ό`BNX^Ƃ͂{[Ɠ`B
	void ComputeClusterDeformation(
		KFbxXMatrix& rGlobalPosition, 
		KFbxMesh* pMesh,
		KFbxCluster* pCluster, 
		KFbxXMatrix& rVertexTransformMatrix,
		KTime rTime, 
		KFbxPose* pPose)
	{
		KFbxCluster::ELinkMode dClusterMode = pCluster->GetLinkMode();

		KFbxXMatrix lReferenceGlobalInitPosition;
		KFbxXMatrix lReferenceGlobalCurrentPosition;
		KFbxXMatrix lAssociateGlobalInitPosition;
		KFbxXMatrix lAssociateGlobalCurrentPosition;
		KFbxXMatrix lClusterGlobalInitPosition;
		KFbxXMatrix lClusterGlobalCurrentPosition;

		KFbxXMatrix lReferenceGeometry;
		KFbxXMatrix lAssociateGeometry;
		KFbxXMatrix lClusterGeometry;

		KFbxXMatrix lClusterRelativeInitPosition;
		KFbxXMatrix lClusterRelativeCurrentPositionInverse;
		
		if (dClusterMode == KFbxLink::eADDITIVE && pCluster->GetAssociateModel())
		{
			pCluster->GetTransformAssociateModelMatrix(lAssociateGlobalInitPosition);
			// Geometric transform of the model
			lAssociateGeometry = GetGeometry(pCluster->GetAssociateModel());
			lAssociateGlobalInitPosition *= lAssociateGeometry;
			lAssociateGlobalCurrentPosition = GetGlobalPosition(pCluster->GetAssociateModel(), rTime, pPose, NULL);

			pCluster->GetTransformMatrix(lReferenceGlobalInitPosition);
			// Multiply lReferenceGlobalInitPosition by Geometric Transformation
			lReferenceGeometry = GetGeometry(pMesh->GetNode());
			lReferenceGlobalInitPosition *= lReferenceGeometry;
			lReferenceGlobalCurrentPosition = rGlobalPosition;

			// Get the link initial global position and the link current global position.
			pCluster->GetTransformLinkMatrix(lClusterGlobalInitPosition);
			// Multiply lClusterGlobalInitPosition by Geometric Transformation
			lClusterGeometry = GetGeometry(pCluster->GetLink());
			lClusterGlobalInitPosition *= lClusterGeometry;
			lClusterGlobalCurrentPosition = GetGlobalPosition(pCluster->GetLink(), rTime, pPose, NULL);

			// Compute the shift of the link relative to the reference.
			//ModelM-1 * AssoM * AssoGX-1 * LinkGX * LinkM-1*ModelM
			rVertexTransformMatrix =
				lReferenceGlobalInitPosition.Inverse()
				* lAssociateGlobalInitPosition * lAssociateGlobalCurrentPosition.Inverse()
				* lClusterGlobalCurrentPosition * lClusterGlobalInitPosition.Inverse() * lReferenceGlobalInitPosition;
		}
		else
		{
			pCluster->GetTransformMatrix(lReferenceGlobalInitPosition);
			lReferenceGlobalCurrentPosition = rGlobalPosition;
			// Multiply lReferenceGlobalInitPosition by Geometric Transformation
			lReferenceGeometry = GetGeometry(pMesh->GetNode());
			lReferenceGlobalInitPosition *= lReferenceGeometry;

			// Get the link initial global position and the link current global position.
			pCluster->GetTransformLinkMatrix(lClusterGlobalInitPosition);
			lClusterGlobalCurrentPosition = GetGlobalPosition(pCluster->GetLink(), rTime, pPose, NULL);

			// Compute the initial position of the link relative to the reference.
			lClusterRelativeInitPosition = lClusterGlobalInitPosition.Inverse() * lReferenceGlobalInitPosition;

			// Compute the current position of the link relative to the reference.
			lClusterRelativeCurrentPositionInverse = lReferenceGlobalCurrentPosition.Inverse() * lClusterGlobalCurrentPosition;

			// Compute the shift of the link relative to the reference.
			rVertexTransformMatrix =
				lClusterRelativeCurrentPositionInverse
				* lClusterRelativeInitPosition;
		}
	}

	// Deform the vertex array in classic linear way.
	void ComputeLinearDeformation(
		KFbxXMatrix& rGlobalPosition, 
		KFbxMesh* pMesh, 
		KTime& rTime, 
		KFbxVector4* pVertexArray,
		KFbxPose* pPose)
	{
		// All the links must have the same link mode.
		KFbxCluster::ELinkMode eClusterMode = ((KFbxSkin*)pMesh->GetDeformer(0, KFbxDeformer::eSKIN))->GetCluster(0)->GetLinkMode();

		const int kVertexCount = pMesh->GetControlPointsCount();
		KFbxXMatrix* pClusterDeformations = NEW KFbxXMatrix[kVertexCount];
		memset(pClusterDeformations, 0, kVertexCount * sizeof(KFbxXMatrix));

		double* pClusterWeights = NEW double[kVertexCount];
		memset(pClusterWeights, 0, kVertexCount * sizeof(double));

		if (eClusterMode == KFbxCluster::eADDITIVE)
		{
			for (int i = 0; i < kVertexCount; ++i)
			{
				pClusterDeformations[i].SetIdentity();
			}
		}

		// For all skins and all clusters, accumulate their deformation and weight
		// on each vertices and store them in pClusterDeformations and pClusterWeights.
		const int kSkinCount = pMesh->GetDeformerCount(KFbxDeformer::eSKIN);
		for ( int skinIndex = 0; skinIndex < kSkinCount; ++skinIndex)
		{
			KFbxSkin* pSkinDeformer = (KFbxSkin*)pMesh->GetDeformer(skinIndex, KFbxDeformer::eSKIN);
			
			const int kClusterCount = pSkinDeformer->GetClusterCount();
			for ( int lClusterIndex=0; lClusterIndex < kClusterCount; ++lClusterIndex)
			{
				KFbxCluster* pCluster = pSkinDeformer->GetCluster(lClusterIndex);
				if (!pCluster->GetLink())
				{
					continue;
				}

				// NX^̕ό`sZo
				KFbxXMatrix vertexTransformMatrix;
				ComputeClusterDeformation(rGlobalPosition, pMesh, pCluster, vertexTransformMatrix, rTime, pPose);

				int kVertexIndexCount = pCluster->GetControlPointIndicesCount();
				for (int k = 0; k < kVertexIndexCount; ++k) 
				{            
					const int kIndex = pCluster->GetControlPointIndices()[k];

					// Sometimes, the mesh can have less points than at the time of the skinning
					// because a smooth operator was active when skinning but has been deactivated during export.
					if (kIndex >= kVertexCount)
					{
						continue;
					}

					const double kWeight = pCluster->GetControlPointWeights()[k];

					if (kWeight == 0.0)
					{
						continue;
					}

					// Compute the influence of the link on the vertex.
					KFbxXMatrix lInfluence = vertexTransformMatrix;
					MathHelper::Multiple(lInfluence, kWeight);

					if (eClusterMode == KFbxCluster::eADDITIVE)
					{    
						// Multiply with the product of the deformations on the vertex.
						MathHelper::AddToDiagnoal(lInfluence, 1.0 - kWeight);
						pClusterDeformations[kIndex] = lInfluence * pClusterDeformations[kIndex];

						// Set the link to 1.0 just to know this vertex is influenced by a link.
						pClusterWeights[kIndex] = 1.0;
					}
					else // lLinkMode == KFbxLink::eNORMALIZE || lLinkMode == KFbxLink::eTOTAL1
					{
						// Add to the sum of the deformations on the vertex.
						MathHelper::Add(pClusterDeformations[kIndex], lInfluence);

						// Add to the sum of weights to either normalize or complete the vertex.
						pClusterWeights[kIndex] += kWeight;
					}
				}//For each vertex			
			}//kClusterCount
		}

		//Actually deform each vertices here by information stored in pClusterDeformations and pClusterWeights
		for (int i = 0; i < kVertexCount; i++) 
		{
			KFbxVector4 srcVertex = pVertexArray[i];
			KFbxVector4& rDstVertex = pVertexArray[i];
			const double kWeight = pClusterWeights[i];

			// Deform the vertex if there was at least a link with an influence on the vertex,
			if (kWeight != 0.0) 
			{
				rDstVertex = pClusterDeformations[i].MultT(srcVertex);
				if (eClusterMode == KFbxCluster::eNORMALIZE)
				{
					// In the normalized link mode, a vertex is always totally influenced by the links. 
					rDstVertex /= kWeight;
				}
				else if (eClusterMode == KFbxCluster::eTOTAL1)
				{
					// In the total 1 link mode, a vertex can be partially influenced by the links. 
					srcVertex *= (1.0 - kWeight);
					rDstVertex += srcVertex;
				}
			} 
		}

		delete[] pClusterDeformations;
		delete[] pClusterWeights;
	}

	// Deform the vertex array according to the links contained in the mesh and the skinning type.
	void ComputeSkinDeformation(
		KFbxXMatrix& rGlobalPosition,
		KFbxMesh* pMesh,
		KTime& rTime,
		KFbxVector4* pVertexArray,
		KFbxPose* pPose
		)
	{
		KFbxSkin* pSkinDeformer = (KFbxSkin*)pMesh->GetDeformer(0, KFbxDeformer::eSKIN);
		KFbxSkin::ESkinningType eSkinningType = pSkinDeformer->GetSkinningType();

		if(eSkinningType == KFbxSkin::eLINEAR || eSkinningType == KFbxSkin::eRIGID)
		{
			// jAό`
			ComputeLinearDeformation(rGlobalPosition, pMesh, rTime, pVertexArray, pPose);
		}
		else if(eSkinningType == KFbxSkin::eDUALQUATERNION)
		{
			// TODO:fANH[^jIό`
			//ComputeDualQuaternionDeformation(rGlobalPosition, pMesh, rTime, pVertexArray, pPose);
			ASSERT_PF(NULL, _T("fANH[^jIό`͖łB"));
		}
		else if(eSkinningType == KFbxSkin::eBLEND)
		{
			ASSERT_PF(NULL, _T("KFbxSkin::eBLEND̕ό`͖łB"));

			int vertexCount = pMesh->GetControlPointsCount();

			KFbxVector4* pVertexArrayLinear = new KFbxVector4[vertexCount];
			memcpy(pVertexArrayLinear, pMesh->GetControlPoints(), vertexCount * sizeof(KFbxVector4));

			KFbxVector4* pVertexArrayDQ = new KFbxVector4[vertexCount];
			memcpy(pVertexArrayDQ, pMesh->GetControlPoints(), vertexCount * sizeof(KFbxVector4));

			// TODO:jAƃfANH[^jI
			ComputeLinearDeformation(rGlobalPosition, pMesh, rTime, pVertexArrayLinear, pPose);
			//ComputeDualQuaternionDeformation(rGlobalPosition, pMesh, rTime, pVertexArrayDQ, pPose);

			// To blend the skinning according to the blend weights
			// Final vertex = DQSVertex * blend weight + LinearVertex * (1- blend weight)
			// DQSVertex: vertex that is deformed by dual quaternion skinning method;
			// LinearVertex: vertex that is deformed by classic linear skinning method;
			int blendWeightsCount = pSkinDeformer->GetControlPointIndicesCount();
			for(int lBWIndex = 0; lBWIndex < blendWeightsCount; ++lBWIndex)
			{
				double lBlendWeight = pSkinDeformer->GetControlPointBlendWeights()[lBWIndex];
				pVertexArray[lBWIndex] = pVertexArrayDQ[lBWIndex] * lBlendWeight + pVertexArrayLinear[lBWIndex] * (1 - lBlendWeight);
			}
		}
	}
	
} // namespace


//====================================================================================================
// Struct
//----------------------------------------------------------------------------------------------------

/// RXgN^
SkinModel::SInstance::SInstance(const D3DXVECTOR4& rPosition,
								bool isVisible)
	: mPosition(rPosition)
	, mIsVisible(isVisible)
{
}


//====================================================================================================
// Operation
//----------------------------------------------------------------------------------------------------

/// RXgN^
SkinModel::SkinModel() :
	mScale(Vector3::One()),
	mRotation(0),
	mPosition(0),
	mCurrentPoseIndex(-1),
	mPFbxSdkManager(NULL),
	mPFbxScene(NULL),
	mIsLoaded(false)
{
}

/// fXgN^
SkinModel::~SkinModel()
{
	// MEMO:}l[W[jΗǂ悤łB
	SAFE_DESTROY(mPFbxSdkManager);
}


/// XV
void SkinModel::Update(float delta)
{
	// Aj[VXV
	if (mPAnimationController)
	{
		mPAnimationController->AdvanceTime(delta);
	}
}

/// `
void SkinModel::Render()
{
	ASSERT_PF(mIsLoaded, _T("bVǂݍ܂Ă܂B"));
	if (!mIsLoaded)
	{
		return;
	}

	// NXi߂ĂɎgȂȂ́B
	KFbxPose* pPose = NULL;
	KFbxAnimLayer* pAnimLayer = NULL;
	KTime time;

	// ꂪ`̎
	ASSERT_PF(mPFbxScene, _T("mPFbxScene܂BLoadMesh͌Ăт܂H"));
	KFbxXMatrix dummy;
	RenderNodeRecursive(
		mPFbxScene->GetRootNode(),
		time,
		pAnimLayer,
		pPose,
		dummy
		);

	return;
}


/// bVǂݍ
bool SkinModel::LoadMesh(const TCHAR* kPFullPath)
{
	PFL(_T(""));
	PFL(_T("ǂݍݏJn\nt@CpX=%s"), kPFullPath);


	// TODO:̏̔j


	// fbx̂݃T|[gB啶B
	TCHAR extentionName[Directory::mStKMaxExtention];
	Directory::GetExtention(kPFullPath, extentionName);
	if (_tcsicmp(extentionName, _T(".fbx")) != 0)
	{
		// HALT:T|[gĂȂgqȂ玀
		HALT(_T("T|[gĂȂgqłB\npX=%s"), kPFullPath);

		return false;
	}


	// ^C}[쐬AvJn
	TCHAR loadTimerName[StringHelper::mStKDefaultBufferSize];
	ZeroMemory(loadTimerName, sizeof(loadTimerName));
	StringHelper::Format(loadTimerName, StringHelper::mStKDefaultBufferSize, _T("SkinModel::Load();\n%s"), kPFullPath);

	Timer loadTimer;
	loadTimer.Start(loadTimerName);


	/* {iIɓǂݍ݊Jn */

	// KFbxSdkManager쐬
	mPFbxSdkManager = KFbxSdkManager::Create();
	ASSERT_PF(mPFbxSdkManager, _T("FBX SDK manager 쐬ł܂łB"));

	// KFbxIOSettings쐬Aݒ
	KFbxIOSettings* pFbxIOSettings = KFbxIOSettings::Create(mPFbxSdkManager, IOSROOT);
	mPFbxSdkManager->SetIOSettings(pFbxIOSettings);

	// sfBNgɂpluginǂݍ
	KString lPath = KFbxGetApplicationDirectory();
#if defined(KARCH_ENV_WIN)
	KString lExtension = "dll";
#elif defined(KARCH_ENV_MACOSX)
	KString lExtension = "dylib";
#elif defined(KARCH_ENV_LINUX)
	KString lExtension = "so";
#endif
	mPFbxSdkManager->LoadPluginsDirectory(lPath.Buffer(), lExtension.Buffer());

	// C|[^[쐬
	KFbxImporter* pFbxImporter = KFbxImporter::Create(mPFbxSdkManager, "Importer");

	// Ηǂ̂܂ō쐬̃bv^Co
	loadTimer.OutputLapTime(_T("܂ňx΂悢"));


	// C|[^[
	bool isSuceededImporterInitialize = false;
	int fileFormat = -1;
#ifdef UNICODE
	// pXCHAR^ɕϊ
	CHAR fullPath[StringHelper::mStKDefaultBufferSize];
	StringHelper::ToMultiByteChar(fullPath, sizeof(fullPath), kPFullPath);

	isSuceededImporterInitialize = pFbxImporter->Initialize(fullPath, fileFormat, mPFbxSdkManager->GetIOSettings());
#else
	isSuceededImporterInitialize = pFbxImporter->Initialize(kPFullPath, fileFormat, pFbxIOSettings);
#endif // UNICODE

	// ASSERT:C|[^[̏ɎsȂ玀B
	ASSERT_PRINTF(isSuceededImporterInitialize, _T("KFbxImporteȑɎs܂B\nPath=%s\n%s"),
		kPFullPath,
		StringHelper::ToWideChar(pFbxImporter->GetLastErrorString()));

	// C|[^[̏ɐȂ
	if (isSuceededImporterInitialize)
	{
		// t@C̃o[W擾
		int mejorVersion = 0;
		int minorVersion = 0;
		int revisionVersion = 0;
		pFbxImporter->GetFileVersion(mejorVersion, minorVersion, revisionVersion);
		PFL(_T("t@Co[W:%d.%d.%d"), mejorVersion, minorVersion, revisionVersion);

		// V[̍쐬
		mPFbxScene = KFbxScene::Create(mPFbxSdkManager, "Scene");
		ASSERT_PRINTF(mPFbxScene, _T("KFbxScene̍쐬Ɏs܂B"));

		// V[̍쐬ɐȂ
		if (mPFbxScene)
		{
			// MEMO:܂ł͈x쐬ăLbVĂŗǂȂB


			// MEMO:f[^oCiƋقǍłB
			// f[^C|[g
			loadTimer.OutputLapTime(_T("C|[gJn"));
			bool isSucceededImporterImport = pFbxImporter->Import(mPFbxScene);
			loadTimer.OutputLapTime(_T("C|[gI"));
			ASSERT_PRINTF(isSucceededImporterImport, _T("C|[gɎs܂B"));

			/*
			*	KFbxAxisSystem͉]Ŏ킹悤Ƃ悤ŁA3DSMaxDirectXւ̍Wϊ͐܂B
			*	Ȗ́ACfbNX̏Ⴄ߂Ƀ|S̃CfbNX]Ă邱ƂA
			*	|[YAj[VɂĒ_̈ʒuϊĂAςɂȂ܂B
			*	̖KFbxAxisSystemgɂgȂɂAs̕ϊOōsƂɂΉKv̂ŁA
			*	KFbxAxisSystemɂ͗炸Oŕϊ邱Ƃɂ܂B
			*	ȂAKFbxAxisSystemConvertScenéAKFbxNodes擾郁\bhɉe܂B
			*/
#if UNUSED
            // Pʎϊ
            KFbxAxisSystem sceneAxisSystem = mPFbxScene->GetGlobalSettings().GetAxisSystem();
			KFbxAxisSystem ourAxisSystem(KFbxAxisSystem::YAxis, KFbxAxisSystem::ParityOdd, KFbxAxisSystem::LeftHanded);
            if(sceneAxisSystem != ourAxisSystem)
            {
				ourAxisSystem.ConvertScene(mPFbxScene);
            }

			// MEMO:Tvł͐FXOsĂ悤Ȃ̂ŁAYȂpɂƂ肠COԂŋL
            // Convert Unit System to what is used in this example, if needed
            KFbxSystemUnit SceneSystemUnit = mPFbxScene->GetGlobalSettings().GetSystemUnit();
            if( SceneSystemUnit.GetScaleFactor() != 1.0 )
            {
                //The unit in this example is centimeter.
                KFbxSystemUnit::cm.ConvertScene(mPFbxScene);
            }
#endif // UNUSED

			/// MEMO:Ô߂ɍs܂B
			/// s{bg̏ݒƃAj[V̑Ήϊ
			KFbxNode* root = mPFbxScene->GetRootNode();
			const float framerate = static_cast<float>(KTime::GetFrameRate(mPFbxScene->GetGlobalSettings().GetTimeMode()));
			root->ResetPivotSetAndConvertAnimation(framerate, false, true, false);

#if UNUSED
            // Get the list of all the cameras in the scene.
            FillCameraArray(mScene, mCameraArray);

            // Convert mesh, NURBS and patch into triangle mesh
            TriangulateRecursive(mScene->GetRootNode());

            // Bake the scene for one frame
            LoadCacheRecursive(mScene, mPFbxCurrentAnimLayer, mFileName, mSupportVBO);
#endif // UNUSED

			// UNDONE:bṼLbV
			LoadCacheRecursive(mPFbxScene, kPFullPath);

#if UNUSED
            // Convert any .PC2 point cache data into the .MC format for 
            // vertex cache deformer playback.
            PreparePointCacheData(mScene);
#endif // UNUSED

            // Get the list of pose in the scene
			// |[Ÿꗗ擾
			FillPoseArray(mPFbxScene, mFbxPoseArray);
		}
	}


	// ^C}[IAʂo
	loadTimer.End();
	loadTimer.OutputResult();

	PFL(_T("ǂݍݏ\nt@CpX=%s"), kPFullPath);
	PFL(_T(""));

	// p̃CX^XƂĒǉ
	AddInstance(1);

	// [hς݃tO𗧂Ă
	mIsLoaded = true;

	return true;
}


//====================================================================================================
// PrivateOperation
//----------------------------------------------------------------------------------------------------

/// Bake node attributes and materials for this scene and load the textures.
void SkinModel::LoadCacheRecursive(KFbxScene* pScene, const TCHAR* pFbxFileName)
{
    // Load the textures into GPU, only for file texture now
    const int kTextureCount = pScene->GetTextureCount();
    for (int textureIndex = 0; textureIndex < kTextureCount; ++textureIndex)
    {
        KFbxTexture* pTex = pScene->GetTexture(textureIndex);
        KFbxFileTexture* pFileTex = KFbxCast<KFbxFileTexture>(pTex);
        if (pFileTex)
        {
			// HACK:΃pXł̃eNX`ǂݍ݂݂
			const tstring kWorkingDir = Directory::GetDirectoryPath(pFbxFileName);
			const tstring kFileName = StringHelper::ToWideChar(pFileTex->GetRelativeFileName());
			const tstring kRelativeFileName = kWorkingDir + kFileName;
			PFL(_T("kWorkingDir:%s"), kWorkingDir.c_str());
			PFL(_T("kRelativeFileName:%s"), kRelativeFileName.c_str());

			// eNX`̓ǂݍ
			SP<Texture2DDX9> pTex;
			bool isTexLoaded = LoadMaterialTexture(kRelativeFileName.c_str(), &pTex);
			if (isTexLoaded)
			{
				// FBX擾l̂܂܂ŕێ
				std::map<tstring, SP<Blast::Graphic::Texture2DDX9>>::value_type pair(kFileName.c_str(), pTex);
				mPMaterialTextures.insert(pair);
			}
			
			WARNING(isTexLoaded, _T("eNX`̓ǂݍ݂Ɏs܂B\npX=%s"), kRelativeFileName.c_str());

			// eNX`ǂݍ߂Ȃ玟
            if (!isTexLoaded)
            {
                continue;
            }
        }
    }

    LoadCacheRecursive(pScene->GetRootNode());
}

// Bake node attributes and materials under this node recursively.
// Currently only mesh, light and material.
void SkinModel::LoadCacheRecursive(KFbxNode* pNode)
{
	// }eÃLbV
    const int materialCount = pNode->GetMaterialCount();
    for (int materialIndex = 0; materialIndex < materialCount; ++materialIndex)
    {
        KFbxSurfaceMaterial* pMaterial = pNode->GetMaterial(materialIndex);
        if (pMaterial && !pMaterial->GetUserDataPtr())
        {
			LoadCacheMaterial(pMaterial);
        }
    }

	// Agr[g炻ꂼ̏LbV
    KFbxNodeAttribute* nodeAttribute = pNode->GetNodeAttribute();
    if (nodeAttribute)
    {
		// TODO:Aj[Vf[^LbVBeCNAJnԁAIԁAϊsA

		// bVLbV
        if (nodeAttribute->GetAttributeType() == KFbxNodeAttribute::eMESH)
        {
            KFbxMesh* pFbxMesh = pNode->GetMesh();
			ASSERT_PF(pFbxMesh, _T("bV擾ł܂łB\nAgr[g̎wɖ͖ł傤H"));
            if (pFbxMesh)
            {
				// UNDONE:bṼLbV
				mPMesh.SetPointer(NEW SkinMesh());
				mPMesh->Initialize(pNode, pFbxMesh);

				/// HACK:Aj[VRg[[쐬Bsvȏꍇł쐬Ă܂ĂB
				mPAnimationController.SetPointer(NEW AnimationController());
            }
        }
        // CgLbV
        else if (nodeAttribute->GetAttributeType() == KFbxNodeAttribute::eLIGHT)
        {
            KFbxLight* pLight = pNode->GetLight();
            if (pLight)
            {
				// UNDONE:Cg̃LbV
				WARNING(NULL, _T("Cg̃LbVłB"));
            }
        }
    }


	// q̐ōċAs
    const int kChildCount = pNode->GetChildCount();
    for (int childIndex = 0; childIndex < kChildCount; ++childIndex)
    {
        LoadCacheRecursive(pNode->GetChild(childIndex));
    }
}

/// }eAǂݍ
void SkinModel::LoadCacheMaterial(KFbxSurfaceMaterial* pMaterial)
{
	// HACK:FBX}eȀLbVAzɒǉB
	SP<MaterialFbx> pCache(NEW MaterialFbx());
	pCache->Initialize(pMaterial);

	mPMaterials.push_back(pCache);
}


/// m[hċA`悷
void SkinModel::RenderNodeRecursive(
	KFbxNode* pNode,
	KTime& rTime,
	KFbxAnimLayer* pAnimLayer,
	KFbxPose* pPose,
	KFbxXMatrix& rParentGlobalPosition
	)
{
	// HACK:O[öʒu擾B|[Yꍇ͐ẽm[hHKvB
	KFbxXMatrix globalPosition = GetGlobalPosition(pNode, rTime, pPose, &rParentGlobalPosition);

	if (pNode->GetNodeAttribute())
	{
		// Geometry offset.
		// it is not inherited by the children.
		// m[h̃WIg񂪎SRTĂ`悷B
		// SRT͍ċA̎qւ͓`ȂB
		KFbxXMatrix geometryOffset = GetGeometry(pNode);
		KFbxXMatrix globalOffPosition = globalPosition * geometryOffset;

		RenderNode(pNode, rTime, pAnimLayer, pPose, rParentGlobalPosition, globalOffPosition);
	}


	// m[h̎qōċA
	const int lChildCount = pNode->GetChildCount();
	for (int lChildIndex = 0; lChildIndex < lChildCount; ++lChildIndex)
	{
		RenderNodeRecursive(pNode->GetChild(lChildIndex), rTime, pAnimLayer, pPose, globalPosition);
	}
}

/// m[h`
void SkinModel::RenderNode(
	KFbxNode* pNode,
	KTime& rTime,
	KFbxAnimLayer* pAnimLayer,
	KFbxPose* pPose,
	KFbxXMatrix& rParentGlobalPostion,
	KFbxXMatrix& rGlobalPostion
	)
{
	// Agr[gŕ򂵂ĕ`悷
	KFbxNodeAttribute* lNodeAttribute = pNode->GetNodeAttribute();
	if (lNodeAttribute)
	{
		// UNDONE:bV̕`
		switch (lNodeAttribute->GetAttributeType())
		{
			case KFbxNodeAttribute::eMESH:
				RenderMesh(pNode, rTime, pAnimLayer, pPose, rGlobalPostion);
				break;
		}

		// MEMO:TṽRs[Ȃ̂CO
		//// All lights has been processed before the whole scene because they influence every geometry.
		//if (lNodeAttribute->GetAttributeType() == KFbxNodeAttribute::eMARKER)
		//{
		//	DrawMarker(pGlobalPosition);
		//}
		//else if (lNodeAttribute->GetAttributeType() == KFbxNodeAttribute::eSKELETON)
		//{
		//	DrawSkeleton(pNode, rParentGlobalPostion, pGlobalPosition);
		//}
		// NURBS and patch have been converted into triangluation meshes.
		//else if (lNodeAttribute->GetAttributeType() == KFbxNodeAttribute::eMESH)
		//{
		//	DrawMesh(pNode, rTime, pAnimLayer, pGlobalPosition, pPose, pShadingMode);
		//}
		//else if (lNodeAttribute->GetAttributeType() == KFbxNodeAttribute::eCAMERA)
		//{
		//	DrawCamera(pNode, rTime, pAnimLayer, pGlobalPosition);
		//}
		//else if (lNodeAttribute->GetAttributeType() == KFbxNodeAttribute::eNULL)
		//{
		//	DrawNull(pGlobalPosition);
		//}
	}
	else
	{
		// MEMO:TṽRs[Ȃ̂CO
		//// Draw a Null for nodes without attribute.
		//DrawNull(pGlobalPosition);
	}
}

/// bV`
void SkinModel::RenderMesh(
	KFbxNode* pNode,
	KTime& rTime,
	KFbxAnimLayer* pAnimLayer,
	KFbxPose* pPose,
	KFbxXMatrix& rGlobalPosition
	)
{
	// VF[_[Ȃreturn
	ASSERT_PF(mPShaderEffect, _T("VF[_[ݒ肳Ă܂B"));
	if (!mPShaderEffect)
	{
		return;
	}


	// UNDONE:XLꍇ̃gXtH[B
    KFbxMesh* pFbxMesh = pNode->GetMesh();

    // No vertex to draw.
	// _Ȃ`悵Ȃ
    const int kVertexCount = pFbxMesh->GetControlPointsCount();
    if (kVertexCount == 0)
    {
        return;
    }


	// sv炵̂CO
	//// 炭͊i[悪Ⴄ̘bƎv܂B
	//const SP<MeshFbxStaticDX9> kPMeshCache = mPMesh;//static_cast<const SP<MeshFbxStaticDX9>>(pFbxMesh->GetUserData());


    // If it has some defomer connection, update the vertices position
	// ftH[}[Ȃ璸_̈ʒuXV邪AT|[gȌȂE
    const bool isHasVertexCache = pFbxMesh->GetDeformerCount(KFbxDeformer::eVERTEX_CACHE) &&
        (static_cast<KFbxVertexCacheDeformer*>(pFbxMesh->GetDeformer(0, KFbxDeformer::eVERTEX_CACHE)))->IsActive();
    const bool isHasShape = (0 < pFbxMesh->GetShapeCount());
    const bool isHasSkin = (0 < pFbxMesh->GetDeformerCount(KFbxDeformer::eSKIN));
    const bool isHasDeformation = (isHasVertexCache || isHasShape || isHasSkin);

    if (isHasDeformation)
    {
        // Active vertex cache deformer will overwrite any other deformer
        if (isHasVertexCache)
        {
			HALT(_T("LbV̓ǂݍݏ̓T|[gĂ܂B"));
        }
        else
        {
            if (isHasShape)
            {
                // Deform the vertex array with the shapes.
				HALT(_T("VFCṽftH[̓T|[gĂ܂B"));
            }
        }
	}

	// Aj[VRg[[ŃAj[VdB
	if (mPAnimationController &&
		0 < mPAnimationController->GetAnimationSetCount())
	{
		mPAnimationController->UpdatePose(rGlobalPosition, pFbxMesh, rTime, pPose);
		const SP<KFbxXMatrix> pMatrix = mPAnimationController->GetClusterDeformations();
		
		// HACK:š^ϊ璷łB
		SP<D3DXMATRIX> pClusterDeformationsDX(NEW D3DXMATRIX[MAX_BONE_MATRICES], true);
		for (int i = 0; i < MAX_BONE_MATRICES; ++i)
		{
			Matrix temp;
			MathHelper::ToMatrix(pMatrix[i], &temp);
			MathHelperDX::ToD3DXMATRIX(temp, &pClusterDeformationsDX[i]);
		}

		mPShaderEffect->SetMatrixArray(ShaderEffectDX9::eVARIABLE_POSE, pClusterDeformationsDX.GetSource(), MAX_BONE_MATRICES);
	}
	else
	{
		D3DXMATRIX poseMats[MAX_BONE_MATRICES];
		ZeroMemory(poseMats, sizeof(poseMats));

		mPShaderEffect->SetMatrixArray(ShaderEffectDX9::eVARIABLE_POSE, poseMats, MAX_BONE_MATRICES);
	}

	// MEMO:ċAIɏ悤ɂȂ̂ň擾
	// [hsVF[_[ɐݒ
	Matrix lS, lR, lT, world;
	lS.CreateScale(mScale);
	lR.CreateRotationZXY(mRotation);
	lT.CreateTranslate(mPosition);

	world =
		MathHelper::ToMatrix(rGlobalPosition) *		//< m[ḧʒu
		MathHelper::CreateZUpRHToYUpLH() *			//< WDirectXɂ
		lS * lR * lT;

	mPShaderEffect->SetMatrix(ShaderEffectDX9::eVARIABLE_WORLD, &world);

	// r[sƎˉesVF[_[ɐݒ
	ASSERT_PF(mPCamera, _T("Jݒ肳Ă܂B"));
	if (mPCamera)
	{
		mPShaderEffect->SetMatrix(ShaderEffectDX9::eVARIABLE_VIEW, &mPCamera->GetViewMatrixRef());
		mPShaderEffect->SetMatrix(ShaderEffectDX9::eVARIABLE_PROJECTION, &mPCamera->GetProjectionMatrixRef());
	}


	// VF[_[ŕ`
	mPMesh->BeginRender();
	unsigned passCount = 0;
	mPShaderEffect->Begin(&passCount);
	for (unsigned i = 0; i < passCount; ++i)
	{
		mPShaderEffect->BeginPass(i);
		for (int j = 0; j < mPMesh->GetSubMeshCount(); ++j)
		{
#if 0	// ̃bV`悵ꍇɗpĂB
			const int kSpecificIndex = 1;
			if (j != kSpecificIndex)
			{
				continue;
			}
#endif
			// UNDONE:}eȀݒ
			SP<MaterialFbx> pMaterial = mPMaterials.at(j);
			const TCHAR* const kPTextureName = pMaterial->GetDiffuse()->mTextureNameStr.c_str();
			if (0 < mPMaterialTextures.count(kPTextureName))
			{
				SP<Texture2DDX9> pTex = mPMaterialTextures[kPTextureName];
				mPShaderEffect->SetTexture(
					ShaderEffectDX9::ToVariableName(ShaderEffectDX9::eVARIABLE_DIFFUSE_TEXTURE),
					pTex->GetTexturePtrRef().GetInterface());
			}
			
			Color& rAmbient = pMaterial->GetAmbient()->mColor;
			mPShaderEffect->SetFloatArray(ShaderEffectDX9::eVARIABLE_AMBIENT_COLOR, rAmbient.GetArray(), Color::mStKColorFactorNoAlphaCount);

			
			// HACK:CX^Xp̏ݒ
			if (!mSInstanceDatas.empty())
			{
				int remainingInstances = GetInstanceCount();
				while (0 < remainingInstances)
				{
					const int kDefinedBatchCount = SkinMesh::MAX_INSTANCE_INDEX;
					int renderInstances = min(remainingInstances, kDefinedBatchCount);

					// `悷̂1ȂȂ獡̃CX^XQ̕`͍sȂ
					bool isVisibleInstances = false;
					for (int i = 0; i < renderInstances; ++i)
					{
						const int kStartIndex = GetInstanceCount() - remainingInstances;
						isVisibleInstances |= mSInstanceDatas.at(i + kStartIndex).mIsVisible;
					}
					if (!isVisibleInstances)
					{
						// c̃CX^XZ
						remainingInstances -= renderInstances;

						continue;
					}

					// ʒu
					D3DXVECTOR4 insPositions[kDefinedBatchCount];
					ZeroMemory(insPositions, sizeof(insPositions));
					for (int i = 0; i < renderInstances; ++i)
					{
						const int kStartIndex = GetInstanceCount() - remainingInstances;
						insPositions[i] = mSInstanceDatas.at(i + kStartIndex).mPosition;
					}

					mPShaderEffect->SetVectorArray(
						ShaderEffectDX9::ToVariableName(ShaderEffectDX9::eVARIABLE_INSTANCE_POSITIONS),
						insPositions,
						renderInstances
						);

					// `tO
					BOOL insVisibles[kDefinedBatchCount];
					ZeroMemory(insVisibles, sizeof(insVisibles));
					for (int i = 0; i < renderInstances; ++i)
					{
						const int kStartIndex = GetInstanceCount() - remainingInstances;
						insVisibles[i] = mSInstanceDatas.at(i + kStartIndex).mIsVisible;
					}

					mPShaderEffect->SetBoolArray(
						ShaderEffectDX9::ToVariableName(ShaderEffectDX9::eVARIABLE_INSTANCE_VISIBLES),
						insVisibles,
						renderInstances
						);

					// Ŏۂɕ`
					mPShaderEffect->CommitChanges();
					mPMesh->Render(j);

					// c̃CX^XZ
					remainingInstances -= renderInstances;
				}
			}
		}
		mPShaderEffect->EndPass();
	}
	mPShaderEffect->End();
}


/// CX^XǉBbVɈϏ܂B
void SkinModel::AddInstance(int count)
{
	ASSERT_PF(mPMesh, _T("bV܂B\nCX^X̒ǉɂ̓bVKvłB"));
	mPMesh->AddInstance(count);

	// CX^Xp̏ɒǉ
	for (int i = 0; i < count; ++i)
	{
		D3DXVECTOR4 translate(0, 0, 0, 0);
		// MEMO:ǉ邾ňʒu炷eXgpłB
		translate.y = 100.0f * GetInstanceCount();
		translate.z = 100.0f * GetInstanceCount();

		SInstance sData(translate, true);
		mSInstanceDatas.push_back(sData);
	}
}

/// UNDONE:CX^XOB̏Ȃ̂œEɏOCX^XȂB
void SkinModel::RemoveInstance(int index, int count)
{
	mPMesh->RemoveInstance(count);
	
	// ̏O
	for (int i = 0; i < count; ++i)
	{
		std::vector<SInstance>::iterator it = mSInstanceDatas.begin();
		std::advance(it, index);
		it = mSInstanceDatas.erase(it);

		// I[ɓB烁𒴉߂Obreak
		if (it == mSInstanceDatas.end())
		{
			break;
		}
	}
}
