#include "SkinMesh.h"

#include "Blast/IO/File.h"
#include "Blast/Graphic/DirectX9/VertexElementFactoryDX9.h"
#include "Blast/Graphic/VertexStreamType.h"
#include "Blast/Graphic/DirectX9/FileTexture2DDX9.h"
#include "Blast/Graphic/MaterialFbx.h"
#include "Blast/Storage/Directory.h"

using namespace std;
using namespace Blast::Graphic;
using namespace Blast::Base;
using namespace Blast::String;
using namespace Blast::IO;
using namespace Blast::Math;
using namespace Blast::Storage;
using namespace fbxsdk_2012_2;


//====================================================================================================
// Nameless
//----------------------------------------------------------------------------------------------------

namespace
{
#if _DEBUG
	#define DUMP_MESH_FBX 0

	/// _v|S̍ő吔
	#define MAX_POLYGON_DUMP_COUNT 300
#endif // _DEBUG

	/// EWnDirectX̍Wnւ̕ϊɂ\ʂtɂȂہAONOFFőΉł܂B
	/// |SƂ̃CfbNXtɂB
	#define INVERT_INDEX

	/// fO\tgɂV̌t̏ꍇɁAONOFFőΉł܂B
	/// UVV𔽓]
	#define FLIP_UV_Y

	/// Op`|S̒_
	#define TRIANGLE_VERTEX_COUNT 3


	// ʒu񖈂float^̐4
	const int VERTEX_STRIDE = 4;

	// @񖈂float^̐3
	const int NORMAL_STRIDE = 3;

	// UV񖈂float^̐2
	const int UV_STRIDE = 2;

	// {[CfbNX̏񖈂int^̐4
	const int BONE_INDEX_STRIDE = 4;

	// {[EFCg̏񖈂float^̐4
	const int BONE_WEIGHT_STRIDE = 4;

} // namespace


//====================================================================================================
// Operation
//----------------------------------------------------------------------------------------------------

/// RXgN^
SkinMesh::SkinMesh()
	: mPFbxNode(NULL)
	, mPFbxMesh(NULL)
	, mVertexCount(0)
	, mInstanceCount(0)
	, mIsHasNormal(false)
	, mIsHasUV(false)
	, mIsHasSkin(false)
	, mIsAllByControlPoint(false)
{
}

/// fXgN^
SkinMesh::~SkinMesh() { }


/// 
void SkinMesh::Initialize(KFbxNode* pFbxNode, KFbxMesh* pFbxMesh)
{
	// ێ
	mPFbxNode = pFbxNode;
	mPFbxMesh = pFbxMesh;

	// m[hȂreturn
    if (!pFbxMesh->GetNode())
	{
        return;
	}


	// e}eApolygonJEg
    const int kPolygonCount = pFbxMesh->GetPolygonCount();
	PFL(_T("|S=%d"), kPolygonCount);

    KFbxLayerElementArrayTemplate<int>* pMaterialIndices = NULL;
    KFbxGeometryElement::EMappingMode eMaterialMappingMode = KFbxGeometryElement::eNONE;
    if (pFbxMesh->GetElementMaterial())
    {
        pMaterialIndices = &pFbxMesh->GetElementMaterial()->GetIndexArray();
        eMaterialMappingMode = pFbxMesh->GetElementMaterial()->GetMappingMode();
        if (pMaterialIndices && eMaterialMappingMode == KFbxGeometryElement::eBY_POLYGON)
        {
            K_ASSERT(pMaterialIndices->GetCount() == kPolygonCount);
            if (pMaterialIndices->GetCount() == kPolygonCount)
            {
				// e}eAfaceJEg
                for (int polygonIndex = 0; polygonIndex < kPolygonCount; ++polygonIndex)
                {
                    const int kMaterialIndex = pMaterialIndices->GetAt(polygonIndex);
                    if (mSubMeshes.GetCount() < kMaterialIndex + 1)
                    {
                        mSubMeshes.Resize(kMaterialIndex + 1);
                    }
                    if (mSubMeshes[kMaterialIndex] == NULL)
                    {
                        mSubMeshes[kMaterialIndex] = new SSubMesh();
                    }
					mSubMeshes[kMaterialIndex]->mTriangleCount += 1;
                }

				// ItZbgL^(_̐)
                const int kMaterialCount = mSubMeshes.GetCount();
                int offset = 0;
                for (int index = 0; index < kMaterialCount; ++index)
                {
					mSubMeshes[index]->mIndexOffset = offset;
                    offset += mSubMeshes[index]->mTriangleCount * 3;

                    // This will be used as counter in the following procedures, reset to zero
                    mSubMeshes[index]->mTriangleCount = 0;
                }
                K_ASSERT(offset == kPolygonCount * 3);
            }
        }
    }

    // All faces will use the same material.
	// SẴ|S}eAŎgpĂ
    if (mSubMeshes.GetCount() == 0)
    {
        mSubMeshes.Resize(1);
        mSubMeshes[0] = new SSubMesh();
    }

    // Congregate all the data of a mesh to be cached in VBOs.
    // If normal or UV is by polygon vertex, record all vertex attributes by polygon vertex.
	// meshɏW܂ĂSăLbVB
    mIsHasNormal = (0 < pFbxMesh->GetElementNormalCount());
    mIsHasUV = (0 < pFbxMesh->GetElementUVCount());
	mIsHasSkin = (0 < pFbxMesh->GetDeformerCount());
    KFbxGeometryElement::EMappingMode eNormalMappingMode = KFbxGeometryElement::eNONE;
    KFbxGeometryElement::EMappingMode eUVMappingMode = KFbxGeometryElement::eNONE;
    if (mIsHasNormal)
    {
		// MEMO:̃CfbNX0̓Tv̂̂܂܂̒lłB
        eNormalMappingMode = pFbxMesh->GetElementNormal(0)->GetMappingMode();
        if (eNormalMappingMode == KFbxGeometryElement::eNONE)
        {
            mIsHasNormal = false;
        }
        if (mIsHasNormal && eNormalMappingMode != KFbxGeometryElement::eBY_CONTROL_POINT)
        {
            mIsAllByControlPoint = false;
        }
    }
    if (mIsHasUV)
    {
		// MEMO:̃CfbNX0̓Tv̂̂܂܂̒lłB
        eUVMappingMode = pFbxMesh->GetElementUV(0)->GetMappingMode();
        if (eUVMappingMode == KFbxGeometryElement::eNONE)
        {
            mIsHasUV = false;
        }
        if (mIsHasUV && eUVMappingMode != KFbxGeometryElement::eBY_CONTROL_POINT)
        {
            mIsAllByControlPoint = false;
        }
    }


    // Allocate the array memory, by control point or by polygon vertex.
	// z̃m(_A|S̒_)
    int polygonVertexCount = pFbxMesh->GetControlPointsCount();
    if (!mIsAllByControlPoint)
    {
        polygonVertexCount = kPolygonCount * TRIANGLE_VERTEX_COUNT;
    }
	mVertexCount = polygonVertexCount;
	PFL(_T("_=%d"), polygonVertexCount);

	// _
	SP<float> pPoints(NEW float[polygonVertexCount * VERTEX_STRIDE], true);

	// @
	SP<float> pNormals;
    if (mIsHasNormal)
    {
        pNormals.SetPointer(NEW float[polygonVertexCount * NORMAL_STRIDE], true);
		PFL(_T("@=%d(_Ɠ)"), polygonVertexCount);
    }

	// UV
    SP<float> pUVs;
    KStringList uvNameStrs;
    pFbxMesh->GetUVSetNames(uvNameStrs);
    const CHAR* uvName = NULL;
    if (mIsHasUV && uvNameStrs.GetCount())
    {
		pUVs.SetPointer(NEW float[polygonVertexCount * UV_STRIDE], true);
		PFL(_T("UV=%d(_Ɠ)"), polygonVertexCount);
        uvName = uvNameStrs[0];
    }

	// {[CfbNXƃ{[EFCg
	SP<BYTE> pBIndices;
	SP<float> pBWeights;
	if (mIsHasSkin)
	{
		// {[CfbNXz̍쐬
		pBIndices.SetPointer(NEW BYTE[polygonVertexCount * BONE_INDEX_STRIDE], true);
#if _DEBUG
		for (int i = 0; i < polygonVertexCount * BONE_INDEX_STRIDE; ++i)
		{
			pBIndices[i] = -1;
		}
#else
		ZeroMemory(pBIndices.GetSource(), sizeof(BYTE) * polygonVertexCount * BONE_INDEX_STRIDE);
#endif
		PFL(_T("{[CfbNX=%d(_Ɠ)"), polygonVertexCount);

		// {[EFCgz̍쐬
		pBWeights.SetPointer(NEW float[polygonVertexCount * BONE_WEIGHT_STRIDE], true);
		ZeroMemory(pBWeights.GetSource(), sizeof(float) * polygonVertexCount * BONE_WEIGHT_STRIDE);
		PFL(_T("{[EFCg=%d(_Ɠ)"), polygonVertexCount);
	}

	// CfbNX
    SP<int> pIndices(NEW int[kPolygonCount * TRIANGLE_VERTEX_COUNT], true);


    // Populate the array with vertex attribute, if by control point.
	// _ȂA_̏zɈړ
    const KFbxVector4* pControlPoints = pFbxMesh->GetControlPoints();
    KFbxVector4 currentVertex;
    KFbxVector4 currentNormal;
    KFbxVector2 currentUV;

    if (mIsAllByControlPoint)
    {
        const KFbxGeometryElementNormal* pNormalElement = NULL;
        const KFbxGeometryElementUV* pUVElement = NULL;
		const KFbxSkin* pSkinDeformer = NULL;
        if (mIsHasNormal)
        {
            pNormalElement = pFbxMesh->GetElementNormal(0);
        }
        if (mIsHasUV)
        {
            pUVElement = pFbxMesh->GetElementUV(0);
        }
		if (mIsHasSkin)
		{
			pSkinDeformer = KFbxCast<KFbxSkin>(pFbxMesh->GetDeformer(0));	// 擪̂݃T|[g
		}

        for (int index = 0; index < polygonVertexCount; ++index)
        {
            // Save the vertex position.
			// _̈ʒuێ
            currentVertex = pControlPoints[index];
            pPoints[index * VERTEX_STRIDE] = static_cast<float>(currentVertex[0]);
            pPoints[index * VERTEX_STRIDE + 1] = static_cast<float>(currentVertex[1]);
            pPoints[index * VERTEX_STRIDE + 2] = static_cast<float>(currentVertex[2]);
            pPoints[index * VERTEX_STRIDE + 3] = 1;

            // Save the normal.
			// @ێ
            if (mIsHasNormal)
            {
                int normalIndex = index;
                if (pNormalElement->GetReferenceMode() == KFbxLayerElement::eINDEX_TO_DIRECT)
                {
                    normalIndex = pNormalElement->GetIndexArray().GetAt(index);
                }
                currentNormal = pNormalElement->GetDirectArray().GetAt(normalIndex);
                pNormals[index * NORMAL_STRIDE] = static_cast<float>(currentNormal[0]);
                pNormals[index * NORMAL_STRIDE + 1] = static_cast<float>(currentNormal[1]);
                pNormals[index * NORMAL_STRIDE + 2] = static_cast<float>(currentNormal[2]);
            }

            // Save the UV.
			// UVێ
            if (mIsHasUV)
            {
                int uvIndex = index;
                if (pUVElement->GetReferenceMode() == KFbxLayerElement::eINDEX_TO_DIRECT)
                {
                    uvIndex = pUVElement->GetIndexArray().GetAt(index);
                }
                currentUV = pUVElement->GetDirectArray().GetAt(uvIndex);
                pUVs[index * UV_STRIDE] = static_cast<float>(currentUV[0]);
                pUVs[index * UV_STRIDE + 1] = static_cast<float>(currentUV[1]);
            }

			// TODO:{[̃CfbNXƃEFCg̏ێ
			if (mIsHasSkin)
			{
				HALT(_T("{[̃CfbNXƃEFCg̏ێ鏈łB"));
			}
        } // polygonVertexCount
    } // mIsAllByControlPoint


    int vertexCount = 0;
    for (int polygonIndex = 0; polygonIndex < kPolygonCount; ++polygonIndex)
    {
        // The material for current face.
		// ݂̃|S̃}eATo
        int kMaterialIndex = 0;
        if (pMaterialIndices && eMaterialMappingMode == KFbxGeometryElement::eBY_POLYGON)
        {
            kMaterialIndex = pMaterialIndices->GetAt(polygonIndex);
        }

        // Where should I save the vertex attribute index, according to the material
		// }eAɑΉ_̑ۑ
        const int kIndexOffset =
			mSubMeshes[kMaterialIndex]->mIndexOffset +
            mSubMeshes[kMaterialIndex]->mTriangleCount * 3;
        for (int verticesIndex = 0; verticesIndex < TRIANGLE_VERTEX_COUNT; ++verticesIndex)
        {
            const int kControlPointIndex = pFbxMesh->GetPolygonVertex(polygonIndex, verticesIndex);
#ifdef INVERT_INDEX	/// |SƂ̃CfbNXtɂ
			const int kIndexOffsetCull = kIndexOffset + (TRIANGLE_VERTEX_COUNT - 1) - verticesIndex;
#else
			const int kIndexOffsetCull = kIndexOffset + verticesIndex;
#endif // INVERT_INDEX

            if (mIsAllByControlPoint)
            {
                pIndices[kIndexOffsetCull] = static_cast<unsigned>(kControlPointIndex);
            }
            // Populate the array with vertex attribute, if by polygon vertex.
            else
            {
                pIndices[kIndexOffsetCull] = static_cast<unsigned>(vertexCount);

				// ʒu擾
                currentVertex = pControlPoints[kControlPointIndex];
                pPoints[vertexCount * VERTEX_STRIDE] = static_cast<float>(currentVertex[0]);
                pPoints[vertexCount * VERTEX_STRIDE + 1] = static_cast<float>(currentVertex[1]);
                pPoints[vertexCount * VERTEX_STRIDE + 2] = static_cast<float>(currentVertex[2]);
                pPoints[vertexCount * VERTEX_STRIDE + 3] = 1;

				// @擾
                if (mIsHasNormal)
                {
                    pFbxMesh->GetPolygonVertexNormal(polygonIndex, verticesIndex, currentNormal);
                    pNormals[vertexCount * NORMAL_STRIDE] = static_cast<float>(currentNormal[0]);
                    pNormals[vertexCount * NORMAL_STRIDE + 1] = static_cast<float>(currentNormal[1]);
                    pNormals[vertexCount * NORMAL_STRIDE + 2] = static_cast<float>(currentNormal[2]);
                }

				// UV擾
                if (mIsHasUV)
                {
                    pFbxMesh->GetPolygonVertexUV(polygonIndex, verticesIndex, uvName, currentUV);
                    pUVs[vertexCount * UV_STRIDE] = static_cast<float>(currentUV[0]);
#ifdef FLIP_UV_Y	// UVV𔽓]
                    pUVs[vertexCount * UV_STRIDE + 1] = static_cast<float>(1.0f - currentUV[1]);
#endif // FLIP_UV_Y
                }
				
				// {[֘Ȁێ
				if (mIsHasSkin)
				{
					const KFbxSkin* pSkinDeformer = NULL;
					pSkinDeformer = KFbxCast<KFbxSkin>(pFbxMesh->GetDeformer(0));	// 擪̂݃T|[g

					// RIGID݂̂T|[g
					ASSERT_PF(pSkinDeformer->GetSkinningType() == KFbxSkin::eRIGID, _T("RIGID݂̂T|[gĂ܂B"));
					if (pSkinDeformer->GetSkinningType() == KFbxSkin::eRIGID)
					{
						int applyCount = 0;

						// {[̃CfbNXƃEFCg̏ێ
						const int kClusterCount = pSkinDeformer->GetClusterCount();
						for (int clusterIndex = 0; clusterIndex < kClusterCount; ++clusterIndex)
						{
							const KFbxCluster* pCluster = pSkinDeformer->GetCluster(clusterIndex);
							// if (!pCluster->GetLink()) { continue; } KvǂȂ̂łƂ肠CO
							int kVertexIndexCount = pCluster->GetControlPointIndicesCount();
							for (int j = 0; j < kVertexIndexCount; ++j)
							{
								const int kCPIndex = pCluster->GetControlPointIndices()[j];
								if (kControlPointIndex == kCPIndex)
								{
									ASSERT_PF(0 <= clusterIndex && clusterIndex <= MAX_BONE_MATRICES, _T("{[CfbNXBYTE^ŕ\͈͂I[o[Ă܂B\nclusterIndex=%d, j=%d"), clusterIndex, j);
									pBIndices[vertexCount * BONE_INDEX_STRIDE + applyCount] = static_cast<BYTE>(clusterIndex);

									// if (kIndex >= kVertexCount) { continue; } KvǂȂ̂łƂ肠CO

									const double kWeight = pCluster->GetControlPointWeights()[j];
									pBWeights[vertexCount * BONE_WEIGHT_STRIDE + applyCount] = static_cast<float>(kWeight);

									++applyCount;

									break;
								}
							} // kVertexIndexCount

							// ݒ\ȃ{[𒴉߂Aȍ~̃{[͏Ȃ
							if (BONE_INDEX_STRIDE <= applyCount)
							{
								WARNING(NULL, _T("1̒_ɐݒ\ȃ{[񂪃I[o[Ă܂B\nkvertexCount=%d\nControlPointIndex=%d\nclusterIndex[%d]=%s\napplyCount=%d  ȍ~̏̓XLbv܂B"),
									vertexCount,
									kControlPointIndex,
									clusterIndex, StringHelper::ToWideChar(pCluster->GetInitialName()).c_str(),
									applyCount + 1);

								break;
							}
						} // kClusterCount
					}
				} // Bone
            }
            ++vertexCount;
        }
        mSubMeshes[kMaterialIndex]->mTriangleCount += 1;
    }

	// CX^XCfbNX쐬
	SP<float> pInstanceIndices(NEW float[polygonVertexCount], true);
	for (int i = 0; i < polygonVertexCount; ++i)
	{
		pInstanceIndices[i] = 0.0f;	///< ͕K0B
	}


	/// ʒuobt@쐬
	mPVertexBuffers[eVERTEXBUFFER_POSITION].SetPointer(NEW VertexBufferDX9());
	mPVertexBuffers[eVERTEXBUFFER_POSITION]->SetVertices(pPoints.GetSource(), polygonVertexCount, polygonVertexCount * VERTEX_STRIDE * sizeof(float));

	// @̃obt@쐬
    if (mIsHasNormal)
    {
		mPVertexBuffers[eVERTEXBUFFER_NORMAL].SetPointer(NEW VertexBufferDX9());
		mPVertexBuffers[eVERTEXBUFFER_NORMAL]->SetVertices(pNormals.GetSource(), polygonVertexCount, polygonVertexCount * NORMAL_STRIDE * sizeof(float));
    }
    
	// UṼobt@쐬
    if (mIsHasUV)
    {
		mPVertexBuffers[eVERTEXBUFFER_UV].SetPointer(NEW VertexBufferDX9());
		mPVertexBuffers[eVERTEXBUFFER_UV]->SetVertices(pUVs.GetSource(), polygonVertexCount, polygonVertexCount * UV_STRIDE * sizeof(float));
    }
    
	// {[̃CfbNXƃEFCg̃obt@쐬
	if (mIsHasSkin)
	{
		mPVertexBuffers[eVERTEXBUFFER_BONE_INDEX].SetPointer(NEW VertexBufferDX9());
		mPVertexBuffers[eVERTEXBUFFER_BONE_INDEX]->SetVertices(pBIndices.GetSource(), polygonVertexCount, polygonVertexCount * BONE_INDEX_STRIDE * sizeof(BYTE));

		mPVertexBuffers[eVERTEXBUFFER_BONE_WEIGHT].SetPointer(NEW VertexBufferDX9());
		mPVertexBuffers[eVERTEXBUFFER_BONE_WEIGHT]->SetVertices(pBWeights.GetSource(), polygonVertexCount, polygonVertexCount * BONE_WEIGHT_STRIDE * sizeof(float));
	}

	// CfbNX̃obt@쐬
	mPIndexBuffer.SetPointer(NEW IndexBufferDX9());
	mPIndexBuffer->SetIndices(pIndices.GetSource(), kPolygonCount * TRIANGLE_VERTEX_COUNT);

	// CX^XCfbNXobt@쐬
	mPVertexBuffers[eVERTEXBUFFER_INSTANCE_INDEX].SetPointer(NEW VertexBufferDX9());
	mPVertexBuffers[eVERTEXBUFFER_INSTANCE_INDEX]->SetVertices(pInstanceIndices.GetSource(), polygonVertexCount, polygonVertexCount * sizeof(float));


	// _`쐬BXL̗LŒ`ςB
	VertexElementFactoryDX9 veFactory;
	mPVertexDeclaration.SetPointer(NEW VertexDeclarationDX9());
	if (mIsHasSkin)
	{
		const D3DVERTEXELEMENT9 elements[] =
		{
			veFactory.CreateElement(VertexElementType::eELEMENT_POSITION),
			veFactory.CreateElement(VertexElementType::eELEMENT_UV),
			veFactory.CreateElement(VertexElementType::eELEMENT_NORMAL),
			veFactory.CreateElement(VertexElementType::eELEMENT_BONE_INDEX),
			veFactory.CreateElement(VertexElementType::eELEMENT_BONE_WEIGHT),
			veFactory.CreateElement(VertexElementType::eELEMENT_INSTANCE_INDEX),
			veFactory.CreateElement(VertexElementType::eELEMENT_END),
		};
		mPVertexDeclaration->CreateDeclaration(elements);
	}
	else
	{
		const D3DVERTEXELEMENT9 elements[] =
		{
			veFactory.CreateElement(VertexElementType::eELEMENT_POSITION),
			veFactory.CreateElement(VertexElementType::eELEMENT_UV),
			veFactory.CreateElement(VertexElementType::eELEMENT_NORMAL),
			veFactory.CreateElement(VertexElementType::eELEMENT_END),
		};
		mPVertexDeclaration->CreateDeclaration(elements);
	}

	// eێBCX^X쐬ׂɕKvɂȂB
	mPVertices[eVERTEXBUFFER_POSITION] = pPoints;
	mPVertices[eVERTEXBUFFER_UV] = pUVs;
	mPVertices[eVERTEXBUFFER_NORMAL] = pNormals;
	mPBoneIndices = pBIndices;
	mPVertices[eVERTEXBUFFER_BONE_WEIGHT] = pBWeights;
	mPIndices = pIndices;


	// CX^VÕeXg
	AddInstance(1);


    return;
}

/// `̑OBVF[_[ŕ`悪JnOɌĂ΂́B
void SkinMesh::BeginRender()
{
	// bVȂ
	ASSERT_PF(mPFbxMesh, _T("bV܂B"));
	if (!mPFbxMesh)
	{
		return;
	}

	GraphicsDeviceDX9* pGraphicsDevice = GraphicsDeviceDX9::GetInstance();
	IDirect3DDevice9* pDevice = pGraphicsDevice->GetDevice();
	HRESULT hr = S_OK;
	
	// ʒuXg[ݒ
	hr = pDevice->SetStreamSource(
		VertexStreamType::eSTREAM_POSITION,
		mPVertexBuffers[eVERTEXBUFFER_POSITION]->GetBuffer(),
		0,
		mPVertexBuffers[eVERTEXBUFFER_POSITION]->GetStride());
	ASSERT_PF(SUCCEEDED(hr), _T("ʒũXg[̐ݒɎs܂B"));

	// UVXg[ݒ
	if (mIsHasUV)
	{
		hr = pDevice->SetStreamSource(
			VertexStreamType::eSTREAM_UV,
			mPVertexBuffers[eVERTEXBUFFER_UV]->GetBuffer(),
			0,
			mPVertexBuffers[eVERTEXBUFFER_UV]->GetStride());
		ASSERT_PF(SUCCEEDED(hr), _T("UṼXg[̐ݒɎs܂B"));
	}

	// @Xg[ݒ
	if (mIsHasNormal)
	{
		hr = pDevice->SetStreamSource(
			VertexStreamType::eSTREAM_NORMAL,
			mPVertexBuffers[eVERTEXBUFFER_NORMAL]->GetBuffer(),
			0,
			mPVertexBuffers[eVERTEXBUFFER_NORMAL]->GetStride());
		ASSERT_PF(SUCCEEDED(hr), _T("@̃Xg[̐ݒɎs܂B"));
	}

	// {[̃Xg[ݒ
	if (mIsHasSkin)
	{
		hr = pDevice->SetStreamSource(
			VertexStreamType::eSTREAM_BONE_INDEX,
			mPVertexBuffers[eVERTEXBUFFER_BONE_INDEX]->GetBuffer(),
			0,
			mPVertexBuffers[eVERTEXBUFFER_BONE_INDEX]->GetStride());
		ASSERT_PF(SUCCEEDED(hr), _T("{[CfbNX̃Xg[̐ݒɎs܂B"));

		hr = pDevice->SetStreamSource(
			VertexStreamType::eSTREAM_BONE_WEIGHT,
			mPVertexBuffers[eVERTEXBUFFER_BONE_WEIGHT]->GetBuffer(),
			0,
			mPVertexBuffers[eVERTEXBUFFER_BONE_WEIGHT]->GetStride());
		ASSERT_PF(SUCCEEDED(hr), _T("{[EFCg̃Xg[̐ݒɎs܂B"));
	}

	// CX^XCfbNXXg[ݒ
	hr = pDevice->SetStreamSource(VertexStreamType::eSTREAM_INSTANCE_INDEX, mPVertexBuffers[eVERTEXBUFFER_INSTANCE_INDEX]->GetBuffer(), 0, mPVertexBuffers[eVERTEXBUFFER_INSTANCE_INDEX]->GetStride());
	ASSERT_PF(SUCCEEDED(hr), _T("CX^XCfbNX̃Xg[̐ݒɎs܂B"));


	// _錾ݒ
	pDevice->SetVertexDeclaration(mPVertexDeclaration->GetDeclaration());

	// CfbNXobt@ݒ
	pDevice->SetIndices(mPIndexBuffer->GetBuffer());
}

/// `
void SkinMesh::Render(int materialIndex)
{
	// bVȂ
	ASSERT_PF(mPFbxMesh, _T("bV܂B"));
	if (!mPFbxMesh)
	{
		return;
	}

	GraphicsDeviceDX9* pGraphicsDevice = GraphicsDeviceDX9::GetInstance();
	IDirect3DDevice9* pDevice = pGraphicsDevice->GetDevice();

	// `
	const int kVertexCount = mVertexCount * mInstanceCount;
	const unsigned kStartIndex = mSubMeshes[materialIndex]->mIndexOffset * mInstanceCount;
	const unsigned kPrimitiveCount = mSubMeshes[materialIndex]->mTriangleCount * mInstanceCount;
	HRESULT hr = pDevice->DrawIndexedPrimitive(
		D3DPT_TRIANGLELIST,
		0,
		0,
		kVertexCount,
		kStartIndex,
		kPrimitiveCount
		);
	ASSERT_PRINTF(SUCCEEDED(hr), _T("`Ɏs܂B"));
}


/// CX^Xǉ
void SkinMesh::AddInstance(int count)
{
	mInstanceCount += count;
	ReCreateBuffers();
}

/// CX^XO
void SkinMesh::RemoveInstance(int count)
{
	mInstanceCount -= count;
	ReCreateBuffers();
}


//====================================================================================================
// Implement
//----------------------------------------------------------------------------------------------------

/// CX^XύXɂobt@̍č쐬s
void SkinMesh::ReCreateBuffers()
{
	// UNDONE:CX^X̐[ɂȂȂAƂ肠obt@͌ێB
	if (mInstanceCount <= 0)
	{
		return;
	}


	// CX^XCfbNX쐬
	SP<float> pInstanceIndices(NEW float[mVertexCount * mInstanceCount], true);
	for (int insIdx = 0; insIdx < mInstanceCount; ++insIdx)
	{
		for (int i = 0; i < mVertexCount; ++i)
		{
			const int kTgtIdx = i + insIdx * mVertexCount;
			pInstanceIndices[kTgtIdx] = static_cast<float>(insIdx % MAX_INSTANCE_INDEX);
		}
	}
#if 0	//< MEMO:_vpBLɂȂ1AɂȂ0B
	PFL(_T("CX^XCfbNX"));
	for (int i = 0; i < mVertexCount * mInstanceCount; ++i)
	{
		// MEMO:_vpłB
		PFL(_T("i=%d, pInstanceIndices[i]=%f"), i, pInstanceIndices[i]);
	}
#endif

	// CX^XCfbNXobt@쐬
	mPVertexBuffers[eVERTEXBUFFER_INSTANCE_INDEX].SetPointer(NEW VertexBufferDX9());
	mPVertexBuffers[eVERTEXBUFFER_INSTANCE_INDEX]->SetVertices(
		pInstanceIndices.GetSource(),
		mVertexCount * mInstanceCount,
		mVertexCount * mInstanceCount * sizeof(float));


	// ʒuobt@č쐬
	SP<float> pInsPoss(NEW float[mVertexCount * VERTEX_STRIDE * mInstanceCount], true);
	for (int instanceIndex = 0; instanceIndex < mInstanceCount; ++instanceIndex)
	{
		float* pDst = pInsPoss.GetSource();
		pDst += instanceIndex * mVertexCount * VERTEX_STRIDE;
		size_t orgSize = mVertexCount * VERTEX_STRIDE * sizeof(float);
		memcpy(pDst, mPVertices[eVERTEXBUFFER_POSITION].GetSource(), orgSize);
	}
#if 0	//< MEMO:_vpBLɂȂ1AɂȂ0B
	PFL(_T("_obt@"));
	for (int i = 0; i < mVertexCount * mInstanceCount; ++i)
	{
		float x = pInsPoss[i * VERTEX_STRIDE + 0];
		float y = pInsPoss[i * VERTEX_STRIDE + 1];
		float z = pInsPoss[i * VERTEX_STRIDE + 2];
		float w = pInsPoss[i * VERTEX_STRIDE + 3];
		PFL(_T("i=%d, pInsPoss=(%f, %f, %f, %f)"), i, x, y, z, w);
	}
#endif
	mPVertexBuffers[eVERTEXBUFFER_POSITION]->SetVertices(
		pInsPoss.GetSource(),
		mVertexCount * mInstanceCount,
		mVertexCount * VERTEX_STRIDE * mInstanceCount * sizeof(float));

	// UVobt@č쐬
	if (mIsHasUV)
	{
		SP<float> pInsUVs(NEW float[mVertexCount * UV_STRIDE * mInstanceCount], true);
		for (int instanceIndex = 0; instanceIndex < mInstanceCount; ++instanceIndex)
		{
			float* pDst = pInsUVs.GetSource();
			pDst += instanceIndex * mVertexCount * UV_STRIDE;
			size_t orgSize = mVertexCount * UV_STRIDE * sizeof(float);
			memcpy(pDst, mPVertices[eVERTEXBUFFER_UV].GetSource(), orgSize);
		}
		mPVertexBuffers[eVERTEXBUFFER_UV]->SetVertices(
			pInsUVs.GetSource(),
			mVertexCount * mInstanceCount,
			mVertexCount * UV_STRIDE * mInstanceCount * sizeof(float));
	}

	// @obt@č쐬
	if (mIsHasNormal)
	{
		SP<float> pInsNormals(NEW float[mVertexCount * NORMAL_STRIDE * mInstanceCount], true);
		for (int instanceIndex = 0; instanceIndex < mInstanceCount; ++instanceIndex)
		{
			float* pDst = pInsNormals.GetSource();
			pDst += instanceIndex * mVertexCount * NORMAL_STRIDE;
			size_t orgSize = mVertexCount * NORMAL_STRIDE * sizeof(float);
			memcpy(pDst, mPVertices[eVERTEXBUFFER_NORMAL].GetSource(), orgSize);
		}
		mPVertexBuffers[eVERTEXBUFFER_NORMAL]->SetVertices(
			pInsNormals.GetSource(),
			mVertexCount * mInstanceCount,
			mVertexCount * NORMAL_STRIDE * mInstanceCount * sizeof(float));
	}
	
	// {[̃CfbNXƃEFCg̃obt@č쐬
	if (mIsHasSkin)
	{
		SP<BYTE> pInsBIndices(NEW BYTE[mVertexCount * BONE_INDEX_STRIDE * mInstanceCount], true);
		for (int instanceIndex = 0; instanceIndex < mInstanceCount; ++instanceIndex)
		{
			BYTE* pDst = pInsBIndices.GetSource();
			pDst += instanceIndex * mVertexCount * BONE_INDEX_STRIDE;
			size_t orgSize = mVertexCount * BONE_INDEX_STRIDE * sizeof(BYTE);
			memcpy(pDst, mPBoneIndices.GetSource(), orgSize);	//< HACK:̒_Ƃ͈ϐŕێĂ邱Ƃɗ
		}
		mPVertexBuffers[eVERTEXBUFFER_BONE_INDEX]->SetVertices(
			pInsBIndices.GetSource(),
			mVertexCount * mInstanceCount,
			mVertexCount * BONE_INDEX_STRIDE * mInstanceCount * sizeof(BYTE));


		SP<float> pInsBWeights(NEW float[mVertexCount * BONE_WEIGHT_STRIDE * mInstanceCount], true);
		for (int instanceIndex = 0; instanceIndex < mInstanceCount; ++instanceIndex)
		{
			float* pDst = pInsBWeights.GetSource();
			pDst += instanceIndex * mVertexCount * BONE_WEIGHT_STRIDE;
			size_t orgSize = mVertexCount * BONE_WEIGHT_STRIDE * sizeof(float);
			memcpy(pDst, mPVertices[eVERTEXBUFFER_BONE_WEIGHT].GetSource(), orgSize);
		}
		mPVertexBuffers[eVERTEXBUFFER_BONE_WEIGHT]->SetVertices(
			pInsBWeights.GetSource(),
			mVertexCount * mInstanceCount,
			mVertexCount * BONE_WEIGHT_STRIDE * mInstanceCount * sizeof(float));
	}

	// CfbNXobt@č쐬B
	// }eAƂɑ˂KvB
	const int kPolygonCount = mPFbxMesh->GetPolygonCount();
	const int kOrgIndexCount = kPolygonCount * TRIANGLE_VERTEX_COUNT;
    SP<int> pIndicesRe(NEW int[kOrgIndexCount * mInstanceCount], true);
	int dstCount = 0;
	for (int sub = 0; sub < mSubMeshes.GetCount(); ++sub)
	{	
		// CX^X̐Rs[
		for (int insIdx = 0; insIdx < mInstanceCount; ++insIdx)
		{
			// ̊Jnʒu
			const int kSrcStartIndex = mSubMeshes[sub]->mIndexOffset;
			const int kSrcIndexCount = mSubMeshes[sub]->mTriangleCount * TRIANGLE_VERTEX_COUNT;
			for (int i = 0 ; i < kSrcIndexCount; ++i)
			{
				const int kIndex = i + kSrcStartIndex;		//< QƂCfbNX
				const int kIndexValue = mPIndices[kIndex];	//< QƂCfbNX̒l
				const int kTgtIndex = dstCount;				//< ̃CfbNX
				const int kTgtIndexValue = kIndexValue + insIdx * kOrgIndexCount;	//< ɑCfbNX̒l
				pIndicesRe[kTgtIndex] = kTgtIndexValue;

				++dstCount;
			}
		}
	}
#if 0	//< MEMO:_vpBLɂȂ1AɂȂ0B
	PFL(_T("CfbNXobt@"));
	for (int i = 0; i < kOrgIndexCount * mInstanceCount; ++i)
	{
		PFL(_T("i=%d, pIndicesRe[i]=%d"), i, pIndicesRe[i]);
	}
#endif
	mPIndexBuffer->SetIndices(pIndicesRe.GetSource(), mPFbxMesh->GetPolygonCount() * TRIANGLE_VERTEX_COUNT * mInstanceCount);
}