#ifndef MAINGAMESEQUENCE_H
#define MAINGAMESEQUENCE_H

#include <list>

#include "Blast/Base/SequenceBase.h"

#include "Blast/Design/MethodExec.h"
#include "Blast/Design/ModeTransistor.h"
#include "Camera2D.h"
#include "Camera3DOperation.h"
#include "Blast/Graphic/DirectX9/SpriteDX9.h"
#include "Blast/Graphic/DirectX9/SpriteAnimationDX9.h"
#include "Blast/Graphic/DirectX9/XYZAxisDX9.h"
#include "Blast/Graphic/DirectX9/GridDX9.h"
#include "Blast/Graphic/DirectX9/BtModelDX9.h"
#include "Blast/Graphic/DirectX9/StaticModelDX9.h"

#include "../SequenceEnum.h"
#include "Character.h"
#include "MessageWindow.h"
#include "Party.h"
#include "Possession.h"
#include "NextFloorTile.h"
#include "DropItem.h"

#include "MainGameStateController.h"
#include "MainGameDataManager.h"
#include "MainGameViewManager.h"


/// CQ[̃V[PX
class MainGameSequence : public Blast::Base::SequenceBase
{
public:
	//====================================================================================================
	// Enumerate
	//----------------------------------------------------------------------------------------------------

	/// `
	enum EMode
	{
		eMODE_PLAYER_WAIT_INPUT,	///< vC[̓͑ҋ@

		/// 񋓗vf̐
		eMODE_COUNT,

		/// ̒l
		eMODE_INITIAL = eMODE_PLAYER_WAIT_INPUT,
	};


	//====================================================================================================
	// Alias
	//----------------------------------------------------------------------------------------------------

	// ͂̏ԏ
	typedef Blast::Design::MethodExec<MainGameSequence> MEState;


	//====================================================================================================
	// Struct
	//----------------------------------------------------------------------------------------------------

	/// l
	struct SInitialData
	{
	public:
		/// RXgN^
		SInitialData() :
		  mDungeonNumber(0),
		  mFloorNumber(1)
		{
		}

		/// _Wԍ
		int mDungeonNumber;

		/// tAԍ
		int mFloorNumber;
	};


	//====================================================================================================
	// Operation
	//----------------------------------------------------------------------------------------------------

	/// RXgN^
	MainGameSequence(const SInitialData* kPData);
	/// fXgN^
	virtual ~MainGameSequence();

	/// 
	virtual void Initialize();
	/// 
	virtual void HandleInput(float);
	/// XV
	virtual void Update(float);
	/// `
	virtual void Render();

	/// ^Cv擾
	virtual int GetType() const { return SequenceEnum::eSEQ_MAINGAME; }

	/// ̃tAւ̃^C擾
	SP<NextFloorTile> GetNextFloorTile() { return mPNextFloorTile; }
	/// G擾
	SP<Character> GetEnemy() { return mPEnemy; }

	/// Ԑ擾
	SP<MainGameStateController> GetStateController() { return mPStateController; }
	/// Ǘ擾
	SP<MainGameDataManager> GetDataManager() { return mPDataManager; }
	/// `Ǘ擾
	SP<MainGameViewManager> GetViewManager() { return mPViewManager; }

private:
	/// ԑJڏ
	Blast::Design::ModeTransistor<MainGameSequence> mModeTransistor;

	/// ̃tAւ̃^C
	SP<NextFloorTile> mPNextFloorTile;

	/// GBΉ܂Be[u܂B
	SP<Character> mPEnemy;

#if _DEBUG
	/// NXwABmFpȂ̂Ŋe탂fɗpӂ̂ł͂ȂA̕ϐg񂷁B
	SP<Blast::Graphic::CrosshairDX9> mPCrosshair;
#endif // _DEBUG

	/// Ԑ
	SP<MainGameStateController> mPStateController;

	/// Ǘ
	SP<MainGameDataManager> mPDataManager;

	/// `Ǘ
	SP<MainGameViewManager> mPViewManager;


	//====================================================================================================
	// Implement
	//----------------------------------------------------------------------------------------------------

	/// p[eB쐬
	void CreateParty();

	/// G쐬
	void CreateEnemy();
};

#endif // MAINGAMESEQUENCE_H