#include "DebugSequence.h"

#include "Blast/Base/SequenceBase.h"
#include "Sequence/Debug/DSModelViewer.h"
#include "Sequence/Debug/DSStaticModelViewer.h"
#include "Sequence/Debug/DebugSequenceMainMenu.h"
#include "Sequence/Debug/DSMap.h"
#include "Sequence/Debug/DebugSequenceDebugPrint.h"
#include "Sequence/Debug/DebugSequenceTextRenderer.h"
#include "Sequence/Debug/DebugSequenceInput.h"
#include "Sequence/Debug/DebugSequenceFPSCounter.h"
#include "Sequence/Debug/DebugSequencePolygon.h"
#include "Sequence/Debug/DebugSequenceMath.h"
#include "Sequence/Debug/DebugSequenceType.h"
#include "Sequence/Debug/DebugSequenceDirectory.h"
#include "Sequence/Debug/DebugSequenceSprite.h"
#include "Sequence/Debug/DebugSequenceLine.h"
#include "Sequence/Debug/DebugSequencePrimitive.h"
#include "Sequence/Debug/DebugSequenceGrid.h"
#include "Sequence/Debug/DebugSequenceSpriteFont.h"
#include "Sequence/Debug/DebugSequenceFade.h"
#include "Sequence/Debug/DebugSequenceMesh.h"
#include "Sequence/Debug/DebugSequenceFile.h"
#include "Sequence/Debug/DebugSequenceSound.h"
#include "Sequence/Debug/Message/DebugSequenceMessage.h"
#include "Sequence/Debug/DebugSequenceFrontend.h"
#include "Sequence/Debug/DebugSequenceGameWindow.h"

#include "Sequence/Debug/DebugSequenceTitle.h"
#include "Sequence/Debug/DebugSequenceMainGame.h"

using namespace Blast::Base;
using namespace Blast::Input;
using namespace Blast::Math;
using namespace Sequence;
using namespace Sequence::Debug;
using namespace Sequence::Debug::Dungeon;
using namespace Sequence::Debug::Message;


//====================================================================================================
// Static
//----------------------------------------------------------------------------------------------------

/// Gg[Q
const TCHAR* DebugSequence::mStKPEntryNames[] =
{
	_T("fr[A["),
	_T("ÓIfr[A["),
	_T("Q[j["),
	_T("}bv"),

	_T("fobO`"),
	_T("eLXg`"),
	_T("͋@\"),
	_T("FPSv"),
	_T("|S`"),
	_T("w"),
	_T("^IuWFNg"),
	_T("fBNg"),
	_T("XvCg"),
	_T("C"),
	_T("v~eBu"),
	_T("Obh"),
	_T("XvCgtHg"),
	_T("tF[h"),
	_T("bV"),
	_T("t@C"),

	_T("TEh"),

	_T("Q[EBhE"),
	_T("bZ[W"),

	_T("tgGh"),

	_T("^Cg"),
	_T("CQ["),
};


//====================================================================================================
// Operation
//----------------------------------------------------------------------------------------------------

/// RXgN^
DebugSequence::DebugSequence()
	: SequenceBase(false)
{
}

/// fXgN^
DebugSequence::~DebugSequence()
{
}


/// 
void DebugSequence::Initialize()
{
	// ̏
	SequenceBase::Initialize();


	PFL(_T("DebugSequenceInitializeĂ΂܂B"));

	// ASSERT:Gg[̎ނƃGg[̕񂪈vĂȂȂ玀
	ASSERT_PRINTF(
		(eDEBUG_ENTRY_COUNT == (sizeof(mStKPEntryNames) / sizeof(mStKPEntryNames[0]))),
		_T("Gg[̎ނƃGg[̐vĂ܂B"));


	// fobOj[̖Oݒ
	mPDebugMenu->GetMenuPropertyRef().mNameStr = _T("<DebugSequence>");


	// Gg[Xg쐬
	MenuEntryListScroll* pEntryList = NEW MenuEntryListScroll();
	pEntryList->SetName(_T("<{V[PXXg>"));
	pEntryList->SetPosition(Vector3(20, 50, 0));

	mPDebugMenu->AddMenuEntryList(SP<IMenuEntryList>(pEntryList));


	// Gg[̐Ń[v
	for (int i = 0; i < eDEBUG_ENTRY_COUNT; ++i)
	{
		// Gg[쐬
		SP<MenuEntry> pME(NEW MenuEntry());
		pME->SetText(mStKPEntryNames[i]);

		// Gg[XgɃGg[ǉ
		pEntryList->AddMenuEntry(pME);
	}
}

/// ͏
void DebugSequence::HandleInput(float delta)
{
	// L[{[h擾
	InputManager* pIM = InputManager::GetInstance();
	IKeyboard* pKB = pIM->GetKeyboard();

	// MEMO:V[PXOƕAʓ|Ȃ̂ŁAOL[ꂽ͖ɂ܂B
	// BackspaceL[ĂȂȂ
	if (!pKB->IsDown(Keys::eKEY_BACKSPACE))
	{
		// ̓͏
		SequenceBase::HandleInput(delta);


		// fobOڂ̑I
		HandleInputDebugEntries(delta);
	}
}


//====================================================================================================
// PrivateOperation
//----------------------------------------------------------------------------------------------------

/// fobOڂ̑I
void DebugSequence::HandleInputDebugEntries(float delta)
{
	// I𒆂̃Gg[Xg擾
	SP<IMenuEntryList> pMEL = mPDebugMenu->GetSelectedMenuEntryList();

	// I𒆂̃Gg[XgȂ
	if (pMEL)
	{
		// L[{[h擾
		IKeyboard* pKB = InputManagerHelper::GetKeyboard();

		// {^ꂽǂ擾
		bool isJustDownDecideKey = pKB->IsJustDown(Keys::eKEY_RETURN);

		// {^ꂽȂ
		if (isJustDownDecideKey)
		{
			// V[PX
			SP<ISequence> pSequence;

			// IĂCfbNXŕ
			int selectedIndex = pMEL->GetSelectedIndex();
			switch (selectedIndex)
			{
				// fr[A[
				case eDEBUG_ENTRY_MODELVIEWER:			pSequence.SetPointer(NEW DSModelViewer());
					break;

				/// ÓIfr[A[
				case eDEBUG_ENTRY_STATICMODELVIEWER:	pSequence.SetPointer(NEW DSStaticModelViewer());
					break;

				// Q[j[
				case eDEBUG_ENTRY_GAMEMENU:				pSequence.SetPointer(NEW DebugSequenceMainMenu());
					break;

				// }bv
				case eDEBUG_ENTRY_MAP:					pSequence.SetPointer(NEW DSMap());
					break;

				// fobO`
				case eDEBUG_ENTRY_DEBUGPRINT:			pSequence.SetPointer(NEW DebugSequenceDebugPrint());
					break;

				// eLXg`
				case eDEBUG_ENTRY_TEXTRENDER:			pSequence.SetPointer(NEW DebugSequenceTextRenderer());
					break;

				// ͋@\
				case eDEBUG_ENTRY_INPUT:				pSequence.SetPointer(NEW DebugSequenceInput());
					break;

				// FPSv
				case eDEBUG_ENTRY_FPS_COUNTER:			pSequence.SetPointer(NEW DebugSequenceFPSCounter());
					break;

				// |S`
				case eDEBUG_ENTRY_POLYGON:				pSequence.SetPointer(NEW DebugSequencePolygon());
					break;

				// w
				case eDEBUG_ENTRY_MATH:					pSequence.SetPointer(NEW DebugSequenceMath());
					break;

				// ^IuWFNg
				case eDEBUG_ENTRY_TYPE_OBJECT:			pSequence.SetPointer(NEW DebugSequenceType());
					break;

				// fBNg
				case eDEBUG_ENTRY_DIRECTORY:			pSequence.SetPointer(NEW DebugSequenceDirectory());
					break;

				// XvCg
				case eDEBUG_ENTRY_SPRITE:				pSequence.SetPointer(NEW DebugSequenceSprite());
					break;

				// Line
				case eDEBUG_ENTRY_LINE:					pSequence.SetPointer(NEW DebugSequenceLine());
					break;

				// v~eBu
				case eDEBUG_ENTRY_PRIMITIVE:			pSequence.SetPointer(NEW DebugSequencePrimitive());
					break;

				// Obh
				case eDEBUG_ENTRY_GRID:					pSequence.SetPointer(NEW DebugSequenceGrid());
					break;

				// XvCgtHg
				case eDEBUG_ENTRY_SPRITEFONT:			pSequence.SetPointer(NEW DebugSequenceSpriteFont());
					break;

				// tF[h
				case eDEBUG_ENTRY_FADE:					pSequence.SetPointer(NEW DebugSequenceFade());
					break;

				// bV
				case eDEBUG_ENTRY_MESH:					pSequence.SetPointer(NEW DebugSequenceMesh());
					break;

				// t@C
				case eDEBUG_ENTRY_FILE:					pSequence.SetPointer(NEW DebugSequenceFile());
					break;


				// TEh
				case eDEBUG_ENTRY_SOUND:				pSequence.SetPointer(NEW DebugSequenceSound());
					break;


				// Q[EBhE
				case eDEBUG_ENTRY_GAMEWINDOW:			pSequence.SetPointer(NEW DebugSequenceGameWindow());
					break;

				// bZ[W
				case eDEBUG_ENTRY_MESSAGE:				pSequence.SetPointer(NEW DebugSequenceMessage());
					break;


				// tgGh
				case eDEBUG_ENTRY_FRONTEND:				pSequence.SetPointer(NEW DebugSequenceFrontend());
					break;


				// ^Cg
				case eDEBUG_ENTRY_TITLE:				pSequence.SetPointer(NEW DebugSequenceTitle());
					break;

				// CQ[
				case eDEBUG_ENTRY_MAINGAME:				pSequence.SetPointer(NEW DebugSequenceMainGame());
					break;


				// P[XOȂ
				default:	PFL(_T("\"%d\"ɑ΂Č菈Ă܂B"), selectedIndex);
					break;
			}

			// V[PXȂ
			if (pSequence)
			{
				// V[PX}l[W[Q
				SequenceManager* pSM = SequenceManager::GetInstance();

				// V[PXǉ
				pSM->AddSequence(pSequence);
			}
		}
	}
}
