#include "Sequence/Debug/Message/DebugSequenceMessage.h"

#include "Camera2D.h"

using namespace Sequence::Debug::Message;
using namespace Blast::Base;
using namespace Blast::Input;
using namespace Blast::Math;
using namespace Blast::Graphic;


//====================================================================================================
// Static
//----------------------------------------------------------------------------------------------------


//====================================================================================================
// Operation
//----------------------------------------------------------------------------------------------------

/// RXgN^
DebugSequenceMessage::DebugSequenceMessage()
	: SequenceBase(false)
{
}

/// fXgN^
DebugSequenceMessage::~DebugSequenceMessage()
{
}


/// 
void DebugSequenceMessage::Initialize()
{
	// ̏
	SequenceBase::Initialize();


	// fobOj[̖Oݒ
	mPDebugMenu->GetMenuPropertyRef().mNameStr = _T("<DebugSequenceMessage>");


	// Gg[Xg쐬
	SP<MenuEntryListScroll> pMELMessage(NEW MenuEntryListScroll());
	pMELMessage->GetPropertyRef().mNameStr = _T("<bZ[W>");
	mPDebugMenu->AddMenuEntryList(pMELMessage);

	SP<MenuEntry> pMEFloorCreate(NEW MenuEntry());
	pMEFloorCreate->SetName(_T("MessageCreate"));
	pMEFloorCreate->SetText(_T("!\"));
	pMELMessage->AddMenuEntry(pMEFloorCreate);

	SP<MenuEntry> pMENextText(NEW MenuEntry());
	pMENextText->SetName(_T("NextText"));
	pMENextText->SetText(_T("!̃bZ[W"));
	pMELMessage->AddMenuEntry(pMENextText);


	// J쐬
	SP<Camera2D> pCamera(NEW Camera2D());
	mPGameComponents->Add(pCamera);

	mPCamera = pCamera;
}

/// 
void DebugSequenceMessage::HandleInput(float delta)
{
	// ̓͏
	SequenceBase::HandleInput(delta);


	// L[{[h擾
	IKeyboard* pKB = InputManagerHelper::GetKeyboard();

	// 肵ȂAe퍀ڂŏ
	if (pKB->IsJustDown(Keys::eKEY_RETURN))
	{
		SP<IMenuEntryList> pList = mPDebugMenu->GetSelectedMenuEntryList();
		SP<IMenuEntry> pEntry = pList->GetSelectedMenuEntry();

		// 荀ڂbZ[WEBhE̍쐬Ȃ
		if (_tcsicmp(pEntry->GetName(), _T("MessageCreate")) == 0)
		{
			mPMessageWindow.SetPointer(NEW MessageWindow());

			Vector3 winPos(SCREEN_SIZE_WIDTH / 2, SCREEN_SIZE_HEIGHT / 2, 0);
			Vector2 winSize(800, 200);
			bool isSuccess = mPMessageWindow->Create(winPos, winSize);
			mPMessageWindow->SetCamera(mPCamera);

			mPMessageWindow->AddText(_T("PD̓eXgłB"));
			mPMessageWindow->AddText(_T("QDeXgłB"));
			mPMessageWindow->AddText(_T("RDeXgłB"));
		}
		
		// 荀ڂ̃eLXg֑Ȃ
		if (_tcsicmp(pEntry->GetName(), _T("NextText")) == 0)
		{
			const float kLifeTime = 2.0f;
			const float kMoveTime = 0.125f;
			mPMessageWindow->NextText(kLifeTime, kMoveTime);
		}
	}
}

/// XV
void DebugSequenceMessage::Update(float delta)
{
	// ̍XV
	SequenceBase::Update(delta);


	// bZ[WEBhE̍XV
	if (mPMessageWindow)
	{
		mPMessageWindow->Update(delta);
	}
}

/// `
void DebugSequenceMessage::Render()
{
	// ̕`揈
	SequenceBase::Render();
	

	// bZ[WEBhE̕`
	if (mPMessageWindow)
	{
		mPMessageWindow->Render();
	}
}
